package ru.yandex.webmaster3.worker.feeds.download;

import com.opencsv.bean.CsvBindByName;
import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.webmaster3.core.download.MdsSerializable;
import ru.yandex.webmaster3.core.feeds.feed.FeedsOfferBanTypeEnum;
import ru.yandex.webmaster3.core.xcelite.annotations.Column;
import ru.yandex.webmaster3.core.xcelite.annotations.Row;

@AllArgsConstructor
@Getter
@Row(colsOrder = {"Domain", "FeedUrl", "OfferId", "Datetime", "Reason", "Comment"})
public class FeedsOfferBansCsvRow implements MdsSerializable {

    @CsvBindByName
    @Column
    private final String domain;

    @CsvBindByName
    @Column
    private final String feedUrl;

    @CsvBindByName
    @Column
    private final String offerId;

    @CsvBindByName
    @Column
    private final String datetime;

    @CsvBindByName
    @Column
    private final String reason;

    @CsvBindByName
    @Column
    private final String comment;
}

