package ru.yandex.webmaster3.worker.feeds.logs;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.webmaster3.core.worker.task.PeriodicTaskType;
import ru.yandex.webmaster3.storage.feeds.logs.SerpdataLogsHistoryCHDao;
import ru.yandex.webmaster3.storage.util.clickhouse2.CHTable;
import ru.yandex.webmaster3.storage.ytimport.YtClickhouseDataLoadType;
import ru.yandex.webmaster3.worker.TaskSchedule;

/**
 * Created by Oleg Bazdyrev on 16/12/2021.
 */
@Slf4j
@Service
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class ImportSerpdataLogsHistoryTask extends ImportFeedsOffersLogsHistoryTask {

    @Override
    protected String getFullTable() {
        return SerpdataLogsHistoryCHDao.TABLE_NAME;
    }

    @Override
    protected CHTable getTable() {
        return SerpdataLogsHistoryCHDao.TABLE;
    }

    @Override
    public PeriodicTaskType getType() {
        return PeriodicTaskType.IMPORT_SERPDATA_LOGS_HISTORY;
    }

    @Override
    protected YtClickhouseDataLoadType getImportType() {
        return YtClickhouseDataLoadType.SERPDATA_LOGS_HISTORY;
    }

    @Override
    public TaskSchedule getSchedule() {
        return TaskSchedule.startByCron("0 12/30 * * * *");
    }


}
