package ru.yandex.webmaster3.worker.fresh;

import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

import ru.yandex.webmaster3.core.checklist.data.SiteProblemContent;
import ru.yandex.webmaster3.core.worker.task.PeriodicTaskType;
import ru.yandex.webmaster3.storage.abt.model.Experiment;

import static ru.yandex.webmaster3.storage.checklist.dao.ChecklistSamplesType.URL_ALERT_5XX;
import static ru.yandex.webmaster3.storage.searchurl.samples.dao.RealtimeUrlHttpCodesCHDao.Record.HttpGroup.SERVER_ERROR;

/**
 * @author kravchenko99
 * @date 4/15/21
 */

@Component
public class EnableRealtimeUrlAlert5xxTask extends EnableRealtimeUrlAlertTask {
    public EnableRealtimeUrlAlert5xxTask() {
        httpGroup = SERVER_ERROR;
        threshold = 0.2;
        samplesType = URL_ALERT_5XX;
        experiment = Experiment.URL_ALERT_5XX;
    }

    @NotNull
    protected SiteProblemContent createSiteProblemContent(long currentHourInterval) {
        return new SiteProblemContent.UrlAlert5xx(currentHourInterval);
    }

    @Override
    public PeriodicTaskType getType() {
        return PeriodicTaskType.ENABLE_REALTIME_URL_ALERT_5XX;
    }
}
