package ru.yandex.webmaster3.worker.host;

import java.util.UUID;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.webmaster3.core.worker.task.PeriodicTaskState;
import ru.yandex.webmaster3.core.worker.task.PeriodicTaskType;
import ru.yandex.webmaster3.core.worker.task.TaskResult;
import ru.yandex.webmaster3.storage.host.service.CommercialOwnersService;
import ru.yandex.webmaster3.worker.PeriodicTask;
import ru.yandex.webmaster3.worker.TaskSchedule;

/**
 * @author leonidrom
 */
@Service
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class ImportCommercialOwnersTask extends PeriodicTask<PeriodicTaskState> {
    private final CommercialOwnersService commercialOwnersService;

    @Override
    public Result run(UUID runId) throws Exception {
        commercialOwnersService.importYtTableToYdb();

        return new Result(TaskResult.SUCCESS);
    }

    @Override
    public PeriodicTaskType getType() {
        return PeriodicTaskType.IMPORT_COMMERCIAL_OWNERS;
    }

    @Override
    public TaskSchedule getSchedule() {
        return TaskSchedule.startByCron("0 0 8 * * *");
    }
}
