package ru.yandex.webmaster3.worker.host.moderation;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.webmaster3.core.worker.task.PeriodicTaskState;
import ru.yandex.webmaster3.core.worker.task.PeriodicTaskType;
import ru.yandex.webmaster3.core.worker.task.TaskResult;
import ru.yandex.webmaster3.storage.host.moderation.camelcase.service.HostDisplayNameModerationYtService;
import ru.yandex.webmaster3.worker.PeriodicTask;
import ru.yandex.webmaster3.worker.TaskSchedule;

import java.util.UUID;

/**
 * @author leonidrom
 */

/**
 * Периодическая таска, которая отгружает запросы на модерацию в Yt
 */
public class HostDisplayNameModerationProcessYtRequestsTask extends PeriodicTask<PeriodicTaskState> {
    private HostDisplayNameModerationYtService hostDisplayNameModerationYtService;

    @Override
    public Result run(UUID runId) throws Exception {
        TaskState ts = new TaskState();
        setState(ts);

        ts.totalRequests = hostDisplayNameModerationYtService.processYtRequests();

        return new Result(TaskResult.SUCCESS);
    }

    @Override
    public PeriodicTaskType getType() {
        return PeriodicTaskType.HOST_DISPLAY_NAME_MODERATION_PROCESS_YT_REQUESTS;
    }

    @Override
    public TaskSchedule getSchedule() {
        // return TaskSchedule.never();
        return TaskSchedule.startByCron("0 0 * * * *");
    }

    @Required
    public void setHostDisplayNameModerationYtService(HostDisplayNameModerationYtService hostDisplayNameModerationYtService) {
        this.hostDisplayNameModerationYtService = hostDisplayNameModerationYtService;
    }

    public class TaskState implements PeriodicTaskState {
        int totalRequests;

        public int getTotalRequests() {
            return totalRequests;
        }
    }
}
