package ru.yandex.webmaster3.worker.host.moderation;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.webmaster3.core.worker.task.PeriodicTaskState;
import ru.yandex.webmaster3.core.worker.task.PeriodicTaskType;
import ru.yandex.webmaster3.core.worker.task.TaskResult;
import ru.yandex.webmaster3.storage.host.moderation.camelcase.service.HostDisplayNameModerationYtService;
import ru.yandex.webmaster3.worker.PeriodicTask;
import ru.yandex.webmaster3.worker.TaskSchedule;

import java.util.UUID;


/**
 * @author leonidrom
 */
public class HostDisplayNameModerationProcessYtResultsTask extends PeriodicTask<PeriodicTaskState> {
    private HostDisplayNameModerationYtService hostDisplayNameModerationYtService;

    @Override
    public Result run(UUID runId) throws Exception {
        TaskState ts = new TaskState();
        setState(ts);

        ts.totalResults = hostDisplayNameModerationYtService.processYtResults();

        return new Result(TaskResult.SUCCESS);
    }

    @Override
    public PeriodicTaskType getType() {
        return PeriodicTaskType.HOST_DISPLAY_NAME_MODERATION_PROCESS_YT_RESULTS;
    }

    @Override
    public TaskSchedule getSchedule() {
        return TaskSchedule.startByCron("0 30 * * * *");
    }

    public class TaskState implements PeriodicTaskState {
        int totalResults;

        public int getTotalResults() {
            return totalResults;
        }
    }

    @Required
    public void setHostDisplayNameModerationYtService(HostDisplayNameModerationYtService hostDisplayNameModerationYtService) {
        this.hostDisplayNameModerationYtService = hostDisplayNameModerationYtService;
    }
}
