package ru.yandex.webmaster3.worker.host.moderation;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.webmaster3.core.worker.task.PeriodicTaskState;
import ru.yandex.webmaster3.core.worker.task.PeriodicTaskType;
import ru.yandex.webmaster3.core.worker.task.TaskResult;
import ru.yandex.webmaster3.storage.host.moderation.regions.service.HostRegionsModerationYtService;
import ru.yandex.webmaster3.worker.PeriodicTask;
import ru.yandex.webmaster3.worker.TaskSchedule;

import java.util.UUID;

/**
 * @author leonidrom
 */
public class HostRegionsModerationProcessYtResultsTask extends PeriodicTask<PeriodicTaskState> {
    private HostRegionsModerationYtService hostRegionsModerationYtService;

    @Override
    public Result run(UUID runId) throws Exception {
        TaskState ts = new TaskState();
        setState(ts);

        ts.totalRequests = hostRegionsModerationYtService.processYtResults();

        return new Result(TaskResult.SUCCESS);
    }

    @Override
    public PeriodicTaskType getType() {
        return PeriodicTaskType.HOST_REGIONS_MODERATION_PROCESS_YT_RESULTS;
    }

    @Override
    public TaskSchedule getSchedule() {
        //return TaskSchedule.never();
        return TaskSchedule.startByCron("0 30 * * * *");
    }

    @Required
    public void setHostRegionsModerationYtService(HostRegionsModerationYtService hostRegionsModerationYtService) {
        this.hostRegionsModerationYtService = hostRegionsModerationYtService;
    }

    public class TaskState implements PeriodicTaskState {
        int totalRequests;

        public int getTotalRequests() {
            return totalRequests;
        }
    }
}
