package ru.yandex.webmaster3.worker.host.verification;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import ru.yandex.webmaster3.core.data.WebmasterUser;
import ru.yandex.webmaster3.core.user.UserVerifiedHost;
import ru.yandex.webmaster3.core.worker.task.PeriodicTaskState;
import ru.yandex.webmaster3.core.worker.task.PeriodicTaskType;
import ru.yandex.webmaster3.core.worker.task.TaskResult;
import ru.yandex.webmaster3.storage.delegation.HostDelegationRecord;
import ru.yandex.webmaster3.storage.delegation.UserHostDelegationsYDao;
import ru.yandex.webmaster3.storage.user.service.UserHostsService;
import ru.yandex.webmaster3.worker.PeriodicTask;
import ru.yandex.webmaster3.worker.TaskSchedule;

/**
 * @author avhaliullin
 */

@Component
@RequiredArgsConstructor
public class CleanDelegationTask extends PeriodicTask<PeriodicTaskState> {

    private final UserHostDelegationsYDao userHostDelegationsYDao;
    private final UserHostsService userHostsService;

    @Override
    //записи создают проблемы, к примеру пользователь удалился, а записи остались, поэтому при следующем подтверждении
    // делегированные права востановятся , в нормальной ситуации не должно такого быть.
    public Result run(UUID runId) throws Exception {
        List<HostDelegationRecord> deletedUsers = new ArrayList<>();
        userHostDelegationsYDao.forEach(
                record -> {
                    if (record.isCancelled()) {
                        return;
                    }
                    UserVerifiedHost verifiedHost =
                            userHostsService.getVerifiedHost(new WebmasterUser(record.getFromUser()),
                                    record.getHostId());
                    if (verifiedHost == null) {
                        deletedUsers.add(record.copyCancelled(record.getFromUser()));
                    }
                }
        );
        userHostDelegationsYDao.addDelegationRecord(deletedUsers);
        return new Result(TaskResult.SUCCESS);
    }

    @Override
    public PeriodicTaskType getType() {
        return PeriodicTaskType.CLEAN_DELEGATION_TASK;
    }

    @Override
    public TaskSchedule getSchedule() {
        return TaskSchedule.startByCron("0 0 4 * * *");
    }
}
