package ru.yandex.webmaster3.worker.host.verification;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;
import ru.yandex.webmaster3.core.worker.client.WorkerClient;
import ru.yandex.webmaster3.core.worker.task.VerifyHostTaskData;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskPriority;
import ru.yandex.webmaster3.storage.events.data.WMCEvent;
import ru.yandex.webmaster3.storage.events.data.events.VerifyHostEvent;
import ru.yandex.webmaster3.storage.events.service.WMCEventsObserver;

import java.io.IOException;

/**
 * @author avhaliullin
 */
public class VerifyHostObserver implements WMCEventsObserver {
    private WorkerClient workerClient;

    @Override
    public boolean observe(WMCEvent event) {
        if (!(event.getContent() instanceof VerifyHostEvent)) {
            return false;
        }

        VerifyHostEvent verifyHostEvent = (VerifyHostEvent) event.getContent();
        workerClient.enqueueTask(
                VerifyHostTaskData.createTaskData(
                        verifyHostEvent.getHostId(),
                        verifyHostEvent.getUserId(),
                        verifyHostEvent.getRecordId(),
                        verifyHostEvent.getVerificationType(),
                        WorkerTaskPriority.HIGH
                )
        );


        return true;
    }

    @Required
    public void setWorkerClient(WorkerClient workerClient) {
        this.workerClient = workerClient;
    }
}
