package ru.yandex.webmaster3.worker.host.verification;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.worker.task.TaskResult;
import ru.yandex.webmaster3.core.worker.task.VerifyWithWhoisTaskData;
import ru.yandex.webmaster3.storage.verification.HostVerifierService;
import ru.yandex.webmaster3.worker.RpsLimitedTask;

/**
 * Ничем не отличается от VerifyHostTask, нужна только для того, чтобы для подтверждений через whois можно было лимитировать RPS
 *
 * @author avhaliullin
 */
@Category("verification")
public class VerifyWithWhoisTask extends RpsLimitedTask<VerifyWithWhoisTaskData> {
    private HostVerifierService hostVerifierService;

    @Override
    public Result run(VerifyWithWhoisTaskData data) throws Exception {
        hostVerifierService.verifyHost(data.getUserId(), data.getHostId(), data.getVerificationRecordId());
        return new Result(TaskResult.SUCCESS);
    }

    @Override
    public Class<VerifyWithWhoisTaskData> getDataClass() {
        return VerifyWithWhoisTaskData.class;
    }

    @Required
    public void setHostVerifierService(HostVerifierService hostVerifierService) {
        this.hostVerifierService = hostVerifierService;
    }
}
