package ru.yandex.webmaster3.worker.hoststat.download;


import com.opencsv.bean.CsvBindByName;
import lombok.Builder;
import lombok.Value;
import org.joda.time.LocalDate;

import ru.yandex.webmaster3.core.download.MdsSerializable;
import ru.yandex.webmaster3.core.xcelite.annotations.Column;
import ru.yandex.webmaster3.core.xcelite.annotations.Row;

/**
 * Created by Oleg Bazdyrev on 16/03/2021.
 */
@Value
@Builder
@Row(colsOrder = {"Value", "Count", "Url", "Last access"})
public class ContentAttrSampleCsvRow implements MdsSerializable {

    @CsvBindByName(column = "Value")
    @Column(name = "Value")
    String value;

    @CsvBindByName(column = "Count")
    @Column(name = "Count")
    Long count;

    @CsvBindByName(column = "Url")
    @Column(name = "Url")
    String url;

    @CsvBindByName(column = "Last access")
    @Column(name = "Last access")
    String lastAccess;

}
