package ru.yandex.webmaster3.worker.http;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.events2.HostEvent;
import ru.yandex.webmaster3.core.events2.client.HostEventLogClient;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.ActionRequest;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.core.http.RequestPostProperty;

/**
 * Это временная ручка, по-хорошему нужно использовать ту же ручку в координаторе - но у нас нет дыр
 * @author avhaliullin
 */
public class AddHostEventAction extends Action<AddHostEventAction.Req, AddHostEventAction.Res> {
    private HostEventLogClient hostEventLogClient;

    @Override
    public Res process(Req request) throws WebmasterException {
        hostEventLogClient.log(request.event);
        return new Res();
    }

    @Required
    public void setHostEventLogClient(HostEventLogClient hostEventLogClient) {
        this.hostEventLogClient = hostEventLogClient;
    }

    public static class Req implements ActionRequest {
        private HostEvent event;

        public HostEvent getEvent() {
            return event;
        }

        @RequestPostProperty(required = true)
        public void setEvent(HostEvent event) {
            this.event = event;
        }
    }

    public static class Res implements ActionResponse.NormalResponse {
    }
}
