package ru.yandex.webmaster3.worker.http;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.joda.time.LocalDate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.ActionRequest;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.storage.digest.DigestAcceptanceYDao;

/**
 * @author shabashoff
 */
@ReadAction
@Component("/digest/approve")
@AllArgsConstructor(onConstructor_ = @Autowired)
public class ApproveDigestAction extends Action<ApproveDigestAction.Req, ApproveDigestAction.Res> {
    private final DigestAcceptanceYDao digestAcceptanceYDao;

    @Override
    public Res process(Req request) throws WebmasterException {
        digestAcceptanceYDao.markAsApproved(request.getDate());
        return new Res(true);
    }

    @Getter
    public static class Req implements ActionRequest {
        private LocalDate date;

        @RequestQueryProperty(required = true)
        public void setDate(LocalDate date) {
            this.date = date;
        }
    }

    @Getter
    @AllArgsConstructor
    public static class Res implements ActionResponse {
        private final boolean status;

        @Override
        public ActionStatus getRequestStatus() {
            return ActionStatus.SUCCESS;
        }
    }
}
