package ru.yandex.webmaster3.worker.http;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.ActionRequest;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskType;
import ru.yandex.webmaster3.worker.queue.TaskQueueService;

/**
 * @author tsyplyaev
 */
public class ClearQueueAction extends Action<ClearQueueAction.Request, ClearQueueAction.Response> {
    private static final Logger log = LoggerFactory.getLogger(ClearQueueAction.class);

    private TaskQueueService taskQueueService;

    @Override
    public Response process(Request request) throws WebmasterException {
        try {
            if (request.getTaskType() != null) {
                taskQueueService.clear(request.getTaskType());
            } else {
                taskQueueService.clear();
            }
        } catch (Exception e) {
            log.error("Unable to clear the queue", e);
        }
        return new Response();
    }

    @Required
    public void setTaskQueueService(TaskQueueService taskQueueService) {
        this.taskQueueService = taskQueueService;
    }

    public static class Request implements ActionRequest {
        private WorkerTaskType taskType = null;

        @RequestQueryProperty(required = false)
        public void setTaskType(WorkerTaskType taskType) {
            this.taskType = taskType;
        }

        public WorkerTaskType getTaskType() {
            return taskType;
        }
    }

    public static class Response implements ActionResponse.NormalResponse {
    }
}
