package ru.yandex.webmaster3.worker.http;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.ActionRequest;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskPriority;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskType;
import ru.yandex.webmaster3.worker.queue.TaskQueueService;

/**
 * @author aherman
 */
public class EnqueueTaskAction extends Action<EnqueueTaskAction.Request, EnqueueTaskAction.Response> {
    private static final Logger log = LoggerFactory.getLogger(EnqueueTaskAction.class);

    private TaskQueueService taskQueueService;

    @Override
    public Response process(Request request) throws WebmasterException {
        if (!taskQueueService.enqueueTask(request.getTaskType(), request.getTaskId(), request.getTaskData(),
                request.getTaskPriority())) {
            throw new WebmasterException("Failed to enqueue task " + request.getTaskType(),
                    new WebmasterErrorResponse.WorkerErrorResponse(getClass(), null));
        }
        return new Response();
    }

    @Required
    public void setTaskQueueService(TaskQueueService taskQueueService) {
        this.taskQueueService = taskQueueService;
    }

    public static class Request implements ActionRequest {
        private String applicationName;
        private String applicationVersion;
        private String applicationHostname;
        private WorkerTaskType taskType;
        private String taskId;
        private String taskData;
        private WorkerTaskPriority taskPriority = WorkerTaskPriority.NORMAL;

        @RequestQueryProperty(required = true)
        public void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public String getApplicationName() {
            return applicationName;
        }

        @RequestQueryProperty(required = true)
        public void setApplicationVersion(String applicationVersion) {
            this.applicationVersion = applicationVersion;
        }

        public String getApplicationVersion() {
            return applicationVersion;
        }

        @RequestQueryProperty(required = true)
        public void setApplicationHostname(String applicationHostname) {
            this.applicationHostname = applicationHostname;
        }

        public String getApplicationHostname() {
            return applicationHostname;
        }

        @RequestQueryProperty(required = true)
        public void setTaskType(WorkerTaskType taskType) {
            this.taskType = taskType;
        }

        public WorkerTaskType getTaskType() {
            return taskType;
        }

        @RequestQueryProperty(required = true)
        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public String getTaskId() {
            return taskId;
        }

        @RequestQueryProperty(required = true)
        public void setTaskData(String taskData) {
            this.taskData = taskData;
        }

        public String getTaskData() {
            return taskData;
        }

        @RequestQueryProperty(required = false)
        public void setTaskPriority(WorkerTaskPriority taskPriority) {
            this.taskPriority = taskPriority;
        }

        public WorkerTaskPriority getTaskPriority() {
            return taskPriority;
        }
    }

    public static class Response implements ActionResponse.NormalResponse {
    }
}
