package ru.yandex.webmaster3.worker.http;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.*;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskDataWrapper;
import ru.yandex.webmaster3.worker.queue.TaskQueueService;

import java.util.List;

/**
 * @author aherman
 */
public class EnqueueTaskListAction extends Action<EnqueueTaskListAction.Request, EnqueueTaskListAction.Response> {
    private static final Logger log = LoggerFactory.getLogger(EnqueueTaskListAction.class);

    private TaskQueueService taskQueueService;

    @Override
    public Response process(Request request) throws WebmasterException {
        boolean result = true;
        log.info("Number of tasks to enqueue: {}", request.getTasks().size());
        for (WorkerTaskDataWrapper task : request.getTasks()) {
            // добавляем все в очередь
            result &= taskQueueService.enqueueTask(task.getTaskType(), task.getTaskId(), task.getTaskData(),
                    task.getTaskPriority());
        }
        if (!result) {
            throw new WebmasterException("Failed to enqueue task(s)",
                    new WebmasterErrorResponse.WorkerErrorResponse(getClass(), null));
        }
        return new Response();
    }

    @Required
    public void setTaskQueueService(TaskQueueService taskQueueService) {
        this.taskQueueService = taskQueueService;
    }

    public static class Request implements ActionRequest {
        private String applicationName;
        private String applicationVersion;
        private String applicationHostname;
        private List<WorkerTaskDataWrapper> tasks;

        public String getApplicationName() {
            return applicationName;
        }

        @RequestQueryProperty(required = true)
        public void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public String getApplicationVersion() {
            return applicationVersion;
        }

        @RequestQueryProperty(required = true)
        public void setApplicationVersion(String applicationVersion) {
            this.applicationVersion = applicationVersion;
        }

        public String getApplicationHostname() {
            return applicationHostname;
        }

        @RequestQueryProperty(required = true)
        public void setApplicationHostname(String applicationHostname) {
            this.applicationHostname = applicationHostname;
        }

        public List<WorkerTaskDataWrapper> getTasks() {
            return tasks;
        }

        @RequestPostProperty(required = true)
        public void setTasks(List<WorkerTaskDataWrapper> tasks) {
            this.tasks = tasks;
        }

        @Override
        public boolean isLoggable() {
            return false;
        }
    }

    public static class Response implements ActionResponse.NormalResponse {
    }
}
