package ru.yandex.webmaster3.worker.http;

import java.util.Comparator;
import java.util.List;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.ActionRequest;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;
import ru.yandex.webmaster3.worker.state.WorkerStateService;

/**
 * @author aherman
 */
@Component("/internal/workers")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class GetWorkersAction extends Action<GetWorkersAction.Request, GetWorkersAction.Response> {
    private final WorkerStateService workerStateService;

    @Override
    public Response process(Request request) throws WebmasterException {
        try {
            List<WorkerStateService.WorkerInfo> workers = workerStateService.getWorkers();
            workers.sort(Comparator.comparing(WorkerStateService.WorkerInfo::getHostname));
            return new Response(workers);
        } catch (Exception ex) {
            throw new WebmasterException("Error running task",
                    new WebmasterErrorResponse.ZookeeperErrorResponse(this.getClass(), ex), ex);
        }
    }

    public static class Request implements ActionRequest {
    }

    public static class Response implements ActionResponse.NormalResponse {
        private final List<WorkerStateService.WorkerInfo> workers;

        public Response(List<WorkerStateService.WorkerInfo> workers) {
            this.workers = workers;
        }

        public List<WorkerStateService.WorkerInfo> getWorkers() {
            return workers;
        }
    }
}
