package ru.yandex.webmaster3.worker.http.abt;


import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.ActionRequest;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.storage.abt.dao.AbtExperimentYDao;
import ru.yandex.webmaster3.storage.abt.hash.AbtHashExperimentYDao;
import ru.yandex.webmaster3.storage.abt.hash.HashField;
import ru.yandex.webmaster3.storage.abt.hash.HashFunction;
import ru.yandex.webmaster3.storage.abt.model.IExperiment;


@WriteAction
@Component("/experiment/addHash")
@AllArgsConstructor(onConstructor_ = @Autowired)
public class AddHashExperimentAction extends Action<AddHashExperimentAction.Req, ActionResponse> {
    private final AbtExperimentYDao abtExperimentYDao;
    private final AbtHashExperimentYDao abtHashExperimentYDao;

    @Override
    public ActionResponse process(Req request) throws WebmasterException {
        IExperiment experiment = abtExperimentYDao.select(request.getExperiment());

        if (experiment != null) {
            abtHashExperimentYDao.insert(
                    request.getExperiment(),
                    request.getGroup(),
                    request.getHashField(),
                    request.getHashFunction(),
                    request.getMinValue() / 100.0d,
                    request.getMaxValue() / 100.0d
            );

            return new Response();
        }

        return new ErrorResponse();
    }


    @Getter
    @Setter(onMethod_ = @RequestQueryProperty(required = true))
    public static class Req implements ActionRequest {
        private String experiment;
        private String group;
        private HashField hashField;
        private HashFunction hashFunction;
        private Integer minValue, maxValue;
    }

    public static class Response implements ActionResponse.NormalResponse {
    }

    @Getter
    @AllArgsConstructor
    public static class ErrorResponse implements ActionResponse.ErrorResponse {
        @Override
        public Enum<?> getCode() {
            return GetExperimentDetailInfoAction.ErrorResponseCode.BAD_EXPERIMENT;
        }
    }
}
