package ru.yandex.webmaster3.worker.http.abt;


import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.ActionRequest;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.storage.abt.dao.AbtExperimentYDao;
import ru.yandex.webmaster3.storage.abt.model.ExperimentScope;


@WriteAction
@Component("/experiment/create")
@AllArgsConstructor(onConstructor_ = @Autowired)
public class CreateExperimentAction extends Action<CreateExperimentAction.Req, ActionResponse> {
    private final AbtExperimentYDao abtExperimentYDao;

    @Override
    public ActionResponse process(Req request) throws WebmasterException {
        abtExperimentYDao.save(
                request.getName(),
                request.getDescription(),
                request.getScope(),
                true
        );

        return new Response();
    }


    @Getter
    @Setter(onMethod_ = @RequestQueryProperty(required = true))
    public static class Req implements ActionRequest {
        private String name;
        private String description;
        private ExperimentScope scope;
    }

    public static class Response implements ActionResponse.NormalResponse {
    }
}
