package ru.yandex.webmaster3.worker.http.abt;

import java.util.Collection;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.ActionRequest;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.storage.abt.AbtService;
import ru.yandex.webmaster3.storage.abt.model.SimpleExperiment;

@ReadAction
@Component("/experiment/all")
@AllArgsConstructor(onConstructor_ = @Autowired)
public class GetExperimentAction extends Action<GetExperimentAction.Req, GetExperimentAction.Res> {
    private final AbtService abtService;

    @Override
    public GetExperimentAction.Res process(GetExperimentAction.Req request) throws WebmasterException {
        var simpleExperiments = abtService.listAllExperiments();
        return new GetExperimentAction.Res(simpleExperiments.values());
    }

    public static class Req implements ActionRequest {
    }

    @Getter
    @AllArgsConstructor
    public static class Res implements ActionResponse.NormalResponse {
        private final Collection<SimpleExperiment> experiments;
    }
}
