package ru.yandex.webmaster3.worker.http.abt;


import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.ActionRequest;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.storage.abt.model.ExperimentScope;


@WriteAction
@Component("/experiment/import")
@AllArgsConstructor(onConstructor_ = @Autowired)
public class ImportExperimentAction extends Action<ImportExperimentAction.Req, ImportExperimentAction.Response> {
    private YtImportExperimentService ytImportExperimentService;

    @Override
    public Response process(Req request) throws WebmasterException {

        YtImportExperimentService.Data data = new YtImportExperimentService.Data(
                request.getExperiment(),
                request.getGroup(),
                request.getYtCluster(),
                request.getYtTable(),
                request.getYtField(),
                request.getScope(),
                request.getTaskType()
        );

        if (request.downloadType.equals("async")) {
            ytImportExperimentService.run(data);
        } else {
            ytImportExperimentService.startTask(data);
        }

        return new Response();
    }


    @Getter
    @Setter(onMethod_ = @RequestQueryProperty(required = true))
    public static class Req implements ActionRequest {
        private String experiment;
        private String group;
        private String ytCluster;
        private String ytTable;
        private String ytField;
        private String downloadType;
        private ExperimentScope scope;
        private YtImportExperimentService.TaskType taskType;
    }

    public static class Response implements ActionResponse.NormalResponse {
    }
}
