package ru.yandex.webmaster3.worker.http.clickhouse;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.worker.http.clickhouse.DeleteClickhouseReplicasAction.Request;
import ru.yandex.webmaster3.worker.http.clickhouse.DeleteClickhouseReplicasAction.Response;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.*;
import ru.yandex.webmaster3.storage.util.clickhouse2.ClickhouseException;
import ru.yandex.webmaster3.storage.util.clickhouse2.ClickhouseQueryContext;
import ru.yandex.webmaster3.storage.util.clickhouse2.ClickhouseServer;

import java.util.List;

/**
 * Created by Oleg Bazdyrev on 02/06/2017.
 */
@WriteAction
@Description("Ручка для удаления таблиц в Clickhouse")
public class DeleteClickhouseReplicasAction extends Action<Request, Response> {

    private ClickhouseServer clickhouseServer;

    @Override
    public Response process(Request request) throws WebmasterException {
        // check for hash
        int actualHash = request.database.hashCode();
        actualHash = 31 * actualHash + request.tables.hashCode();
        if (actualHash != request.hash) {
            throw new WebmasterException("Wrong hash",
                    new WebmasterErrorResponse.IllegalParameterValueResponse(getClass(), "hash", String.valueOf(request.hash)));
        }
        // drop all
        ClickhouseQueryContext.Builder context = ClickhouseQueryContext.useDefaults();
        for (String table : request.tables) {
            try {
                clickhouseServer.executeOnAllHosts(context, "DROP TABLE IF EXISTS " + request.database + "." + table);
            } catch (ClickhouseException e) {
                throw new WebmasterException("Error dropping table in Clickhouse",
                        new WebmasterErrorResponse.ClickhouseErrorResponse(getClass(), "DROP TABLE", e), e);
            }
        }
        return new Response();
    }

    @Required
    public void setClickhouseServer(ClickhouseServer clickhouseServer) {
        this.clickhouseServer = clickhouseServer;
    }

    public static class Request implements ActionRequest {

        private String database;
        private List<String> tables;
        private int hash;

        @RequestQueryProperty(required = true)
        @Description("БД, в которой требуется удалить таблицы")
        public void setDatabase(String database) {
            this.database = database;
        }

        @RequestQueryProperty(required = true)
        @Description("Список таблиц, которые необходимо удалить")
        public void setTables(List<String> tables) {
            this.tables = tables;
        }

        @RequestQueryProperty(required = true)
        @Description("Java-хэш от названия БД и таблиц для проверки удаления")
        public void setHash(int hash) {
            this.hash = hash;
        }
    }

    public static class Response implements ActionResponse.NormalResponse {

    }
}
