package ru.yandex.webmaster3.worker.http.clickhouse;

import java.util.List;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.ActionRequest;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;
import ru.yandex.webmaster3.storage.util.ydb.exception.WebmasterYdbException;
import ru.yandex.webmaster3.storage.clickhouse.replication.dao.ClickhouseReplicationQueueYDao;
import ru.yandex.webmaster3.storage.clickhouse.replication.data.ClickhouseReplicationTaskGroup;
import ru.yandex.webmaster3.worker.http.clickhouse.GetClickhouseReplicationQueueAction.Request;
import ru.yandex.webmaster3.worker.http.clickhouse.GetClickhouseReplicationQueueAction.Response;

/**
 * @author Oleg Bazdyrev
 */
@ReadAction
@Description("Ручка для получения информации об очереди реплации данных в ClickHouse")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
@Component("/internal/clickhouse/replication/queue")
public class GetClickhouseReplicationQueueAction extends Action<Request, Response> {

    private final ClickhouseReplicationQueueYDao clickhouseReplicationQueueYDao;

    @Override
    public Response process(Request request) throws WebmasterException {
        try {
            return new Response(clickhouseReplicationQueueYDao.listTasks());
        } catch (WebmasterYdbException e) {
            throw new WebmasterException("Error when reading clickhouse replication queue",
                    new WebmasterErrorResponse.YDBErrorResponse(getClass(), e), e);
        }
    }

    public static class Request implements ActionRequest {

    }

    public static class Response implements ActionResponse.NormalResponse {

        private final List<ClickhouseReplicationTaskGroup> queue;

        public Response(List<ClickhouseReplicationTaskGroup> queue) {
            this.queue = queue;
        }

        public List<ClickhouseReplicationTaskGroup> getQueue() {
            return queue;
        }
    }
}
