package ru.yandex.webmaster3.worker.http.clickhouse;

import java.util.List;
import java.util.stream.Collectors;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.ActionRequest;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.storage.ytimport.YtClickhouseImportState;
import ru.yandex.webmaster3.storage.ytimport.dao.YtClickhouseImportQueueYDao;
import ru.yandex.webmaster3.worker.http.clickhouse.GetClickhouseYtImportQueueAction.Request;
import ru.yandex.webmaster3.worker.http.clickhouse.GetClickhouseYtImportQueueAction.Response;

/**
 * @author Oleg Bazdyrev
 */
@ReadAction
@Description("Ручка для получения информации об очереди импорта данных из Yt в Clickhouse")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class GetClickhouseYtImportQueueAction extends Action<Request, Response> {

    private final YtClickhouseImportQueueYDao ytClickhouseImportQueueYDao;

    @Override
    public Response process(Request request) throws WebmasterException {
        return new Response(ytClickhouseImportQueueYDao.listAll().stream()
                .map(YtClickhouseImportQueueYDao.YtClickhouseImportRecord::toState)
                .collect(Collectors.toList()));
    }

    public static class Request implements ActionRequest {
    }

    public static class Response implements ActionResponse.NormalResponse {
        private final List<YtClickhouseImportState> queue;

        public Response(List<YtClickhouseImportState> queue) {
            this.queue = queue;
        }

        public List<YtClickhouseImportState> getQueue() {
            return queue;
        }
    }
}
