package ru.yandex.webmaster3.worker.http.digest;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.ActionRequest;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.storage.host.CommonDataType;
import ru.yandex.webmaster3.storage.settings.SettingsService;

@AllArgsConstructor(onConstructor_ = @Autowired)
public class ChangeCustomBlockAction extends Action<ChangeCustomBlockAction.Request, ChangeCustomBlockAction.Response> {

    private final SettingsService settingsService;

    @Override
    public ChangeCustomBlockAction.Response process(ChangeCustomBlockAction.Request request) throws WebmasterException {
        System.out.println(request);

        if (request.getRuText() != null) {
            settingsService.update(CommonDataType.DIGEST_CUSTOM_BLOCK_RU, request.getRuText());
        }
        if (request.getEnText() != null) {
            settingsService.update(CommonDataType.DIGEST_CUSTOM_BLOCK_EN, request.getEnText());
        }
        return new Response();
    }

    public static class Response implements ActionResponse {
        @Override
        public ActionStatus getRequestStatus() {
            return ActionStatus.SUCCESS;
        }
    }

    @Getter
    @Setter(onMethod_ = @RequestQueryProperty)
    @ToString
    public static class Request implements ActionRequest {
        private String ruText, enText;
    }
}
