package ru.yandex.webmaster3.worker.http.periodic;

import java.util.UUID;

import org.joda.time.DateTime;

import ru.yandex.webmaster3.core.http.ActionRequest;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.storage.logging.TaskLogEntry;
import ru.yandex.webmaster3.storage.logging.TasksLoggingCHDao;
import ru.yandex.webmaster3.storage.util.clickhouse2.query.OrderBy;

/**
 * @author aherman
 */
public class GetPeriodicTasksLogRequest implements ActionRequest {
    private DateTime fromDate;
    private DateTime toDate;
    private TaskLogEntry.EventType eventType;
    private String taskType;
    private String hostName;
    private UUID runId;
    private Integer page = 1;
    private Integer pageSize = 100;
    private TasksLoggingCHDao.Fields orderBy;
    private OrderBy.Direction orderDirection;
    private Boolean hideZero = false;

    @RequestQueryProperty
    public void setP(int page) {
        this.page = page;
    }

    @RequestQueryProperty
    public void setPSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getPage() {
        return page;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public DateTime getFromDate() {
        return fromDate;
    }

    @RequestQueryProperty
    public void setFromDate(DateTime fromDate) {
        this.fromDate = fromDate;
    }

    public DateTime getToDate() {
        return toDate;
    }

    @RequestQueryProperty
    public void setToDate(DateTime toDate) {
        this.toDate = toDate;
    }

    public TaskLogEntry.EventType getEventType() {
        return eventType;
    }

    @RequestQueryProperty
    public void setEventType(TaskLogEntry.EventType eventType) {
        this.eventType = eventType;
    }

    public String getTaskType() {
        return taskType;
    }

    @RequestQueryProperty
    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public String getHostName() {
        return hostName;
    }

    @RequestQueryProperty
    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public UUID getRunId() {
        return runId;
    }

    @RequestQueryProperty
    public void setRunId(UUID runId) {
        this.runId = runId;
    }

    public TasksLoggingCHDao.Fields getOrderBy() {
        return orderBy;
    }

    @RequestQueryProperty
    public void setOrderBy(TasksLoggingCHDao.Fields orderBy) {
        this.orderBy = orderBy;
    }

    public OrderBy.Direction getOrderDirection() {
        return orderDirection;
    }

    @RequestQueryProperty
    public void setOrderDirection(OrderBy.Direction orderDirection) {
        this.orderDirection = orderDirection;
    }

    @RequestQueryProperty
    public void setHideZero(Boolean hideZero) {
        this.hideZero = hideZero;
    }

    public Boolean getHideZero() {
        return hideZero;
    }
}
