package ru.yandex.webmaster3.worker.http.periodic;

import java.util.List;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.storage.logging.TaskLogEntry;

/**
 * @author aherman
 */
public class GetPeriodicTasksLogResponse implements ActionResponse.NormalResponse {
    private final long count;
    private final List<TaskLogEntry> entries;
    private final List<String> taskTypes;
    private final TaskLogEntry.EventType[] eventTypes = TaskLogEntry.EventType.values();
    private final List<String> hostNames;

    public GetPeriodicTasksLogResponse(long count, List<TaskLogEntry> entries, List<String> taskTypes,
            List<String> hostNames)
    {
        this.count = count;
        this.entries = entries;
        this.taskTypes = taskTypes;
        this.hostNames = hostNames;
    }

    public long getCount() {
        return count;
    }

    public List<TaskLogEntry> getEntries() {
        return entries;
    }

    public List<String> getTaskTypes() {
        return taskTypes;
    }

    public TaskLogEntry.EventType[] getEventTypes() {
        return eventTypes;
    }

    public List<String> getHostNames() {
        return hostNames;
    }
}
