package ru.yandex.webmaster3.worker.http.periodic;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.Action;
import ru.yandex.webmaster3.core.http.ActionRequest;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.worker.task.PeriodicTaskType;
import ru.yandex.webmaster3.worker.SimpleZkScheduler;

/**
 * @author tsyplyaev
 */
public class ResumePeriodicAction extends Action<ResumePeriodicAction.Request, ResumePeriodicAction.Response> {
    private static final Logger log = LoggerFactory.getLogger(ResumePeriodicAction.class);

    private SimpleZkScheduler simpleZkScheduler;

    @Override
    public Response process(Request request) throws WebmasterException {
        try {
            simpleZkScheduler.resume(request.getTaskType());
        } catch (Exception e) {
            log.error("Unable to resume the queue", e);
        }
        return new Response();
    }

    @Required
    public void setSimpleZkScheduler(SimpleZkScheduler simpleZkScheduler) {
        this.simpleZkScheduler = simpleZkScheduler;
    }

    public static class Request implements ActionRequest {
        private PeriodicTaskType taskType = null;

        public PeriodicTaskType getTaskType() {
            return taskType;
        }

        @RequestQueryProperty(required = true)
        public void setTaskType(PeriodicTaskType taskType) {
            this.taskType = taskType;
        }
    }

    public static class Response implements ActionResponse.NormalResponse {
    }
}
