package ru.yandex.webmaster3.worker.iks;

import ru.yandex.webmaster3.core.worker.task.PeriodicTaskType;
import ru.yandex.webmaster3.storage.clickhouse.TableType;
import ru.yandex.webmaster3.storage.iks.dao.MdbIksCHDao;
import ru.yandex.webmaster3.storage.util.clickhouse2.CHTable;
import ru.yandex.webmaster3.storage.yql.YqlFunctions;
import ru.yandex.webmaster3.storage.yql.YqlQueryBuilder;
import ru.yandex.webmaster3.storage.ytimport.YtClickhouseDataLoad;
import ru.yandex.webmaster3.storage.ytimport.YtClickhouseDataLoadType;
import ru.yandex.webmaster3.worker.TaskSchedule;
import ru.yandex.webmaster3.worker.turbo.AbstractYqlPrepareImportTask;

/**
 * Created by Oleg Bazdyrev on 18/03/2021.
 */
public class MdbImportIksTask extends AbstractYqlPrepareImportTask {

    private static final int ROW_COUNT = 128;

    @Override
    protected int getShardsCount() {
        return 1;
    }

    @Override
    protected YqlQueryBuilder prepareIntermediateTable(YtClickhouseDataLoad imprt) {
        YqlQueryBuilder queryBuilder = new YqlQueryBuilder();
        queryBuilder
                .cluster(tablePath)
                .appendText("PRAGMA yt.MaxRowWeight = '128M';\n")
                .appendText("PRAGMA yt.DefaultMemoryLimit = '4G';\n\n")
                .appendFDefinition(YqlFunctions.ESCAPE)
                .appendText("INSERT INTO " + INTERMEDIATE_TABLE)
                .appendText("SELECT ShardId, RowId, Compress::Gzip(String::JoinFromList(AGGREGATE_LIST(data), ''), 6) as data FROM\n")
                .appendText("(\n")
                .appendText("  SELECT\n")
                .appendText("    (Digest::Fnv64(Owner) % " + getShardsCount() + ") as ShardId,\n")
                .appendText("    (Digest::CityHash(Owner) % " + ROW_COUNT + ") as RowId,\n")
                .appendText("    (Owner || '\\t' ||\n")
                .appendText("    '" + imprt.getDateFrom().toString() + "' || '\\t' ||\n")
                .appendText("    MainMirror || '\\t' ||\n")
                .appendText("    cast(nvl(IKS, 0) as String) || '\\t' ||\n")
                .appendText("    cast(nvl(PreviousIKS, 0) as String) || '\\t' ||\n")
                .appendText("    $escape(nvl(Title, '')) || '\\n'\n")
                .appendText("    ) as data\n")
                .appendText("  FROM").appendTable(imprt.getSourceTable()).appendText("\n")
                .appendText(")\n")
                .appendText("GROUP BY ShardId, RowId;\n")
                .appendText("COMMIT;\n\n");

        return queryBuilder;
    }

    @Override
    protected CHTable getTable() {
        return MdbIksCHDao.LAST_STATE_TABLE;
    }

    @Override
    protected TableType getTableType() {
        return TableType.IKS;
    }

    @Override
    protected YtClickhouseDataLoadType getImportType() {
        return YtClickhouseDataLoadType.IKS;
    }

    @Override
    public PeriodicTaskType getType() {
        return PeriodicTaskType.MDB_IMPORT_IKS;
    }

    @Override
    public TaskSchedule getSchedule() {
        return TaskSchedule.startByCron("0 0/30 * * * *");
    }
}
