package ru.yandex.webmaster3.worker.indexing;

import org.joda.time.Instant;
import org.joda.time.LocalDate;

import ru.yandex.webmaster3.storage.indexing2.history.dao.IndexingHistoryTablesUtil;
import ru.yandex.webmaster3.storage.indexing2.internal.data.IndexingHistoryImportType;

/**
 * @author avhaliullin
 */
public class ImportIndexingCountHistoryTask extends AbstractImportIndexingHistoryTask {
    @Override
    protected String getMrTaskName() {
        return "INDEXED_URLS_COUNT";
    }

    @Override
    protected String getTableName(LocalDate date) {
        return IndexingHistoryTablesUtil.getIndexedUrlsCountTableName(date, date);
    }

    @Override
    protected String getTableCreateSpec(LocalDate tableDate, Instant updateTime) {
        return IndexingHistoryTablesUtil.getIndexedUrlsCountUpdTableCreateSpec(tableDate, updateTime);
    }

    @Override
    protected String getDBName() {
        return IndexingHistoryTablesUtil.DATABASE_NAME;
    }

    @Override
    protected String getInsertSpec() {
        return IndexingHistoryTablesUtil.INDEXED_URLS_COUNT_INSERT_SPEC;
    }

    @Override
    protected IndexingHistoryImportType getImportType() {
        return IndexingHistoryImportType.URLS_COUNT_HISTORY;
    }

}
