package ru.yandex.webmaster3.worker.indexing;

import org.joda.time.Instant;
import org.joda.time.LocalDate;

import ru.yandex.webmaster3.core.worker.task.PeriodicTaskType;
import ru.yandex.webmaster3.storage.indexing2.internal.data.IndexingSamplesImportType;
import ru.yandex.webmaster3.storage.indexing2.samples.dao.IndexingEventSamplesCHDao;

/**
 * @author avhaliullin
 */
public class ImportIndexingEventSamplesTask extends AbstractImportIndexingSamplesTask {

    @Override
    protected IndexingSamplesImportType getImportType() {
        return IndexingSamplesImportType.EVENT_SAMPLES;
    }

    @Override
    protected String getMrTaskName() {
        return "INDEXING_EVENT_SAMPLES";
    }

    @Override
    protected String getInsertSpec() {
        return "(host_id, last_access, path, prev_http_code, cur_http_code) FORMAT TabSeparated";
    }

    @Override
    protected String getDBName() {
        return "webmaster3_indexing";
    }

    @Override
    protected String getTableCreateSpec(LocalDate tableDate, Instant updateTime, int part) {
        return "(host_id String, last_access Int64, path String, prev_http_code Int32, cur_http_code Int32) " +
                "ENGINE = ReplicatedMergeTree('/webmaster3/clickhouse/tables/{shard}/webmaster3_indexing/"
                + getTableName(tableDate) + "_" + updateTime.getMillis() + "_" + part + "', '{replica}') " +
                "PARTITION BY cityHash64(host_id) % 16 ORDER BY (host_id, last_access)";
    }

    @Override
    protected String getTableNamePrefix() {
        return "indexing_event_samples_part_";
    }

    @Override
    protected int getPartsCount() {
        return IndexingEventSamplesCHDao.PART_COUNT;
    }

    @Override
    public PeriodicTaskType getType() {
        return PeriodicTaskType.MDB_IMPORT_INDEXING_EVENT_SAMPLES;
    }
}
