package ru.yandex.webmaster3.worker.indexing;

import org.joda.time.Instant;
import org.joda.time.LocalDate;

import ru.yandex.webmaster3.storage.indexing2.history.dao.IndexingHistoryTablesUtil;
import ru.yandex.webmaster3.storage.indexing2.internal.data.IndexingHistoryImportType;

/**
 * @author avhaliullin
 */
public class ImportIndexingEventsHistoryTask extends AbstractImportIndexingHistoryTask {
    @Override
    protected String getMrTaskName() {
        return "INDEXING_EVENTS_COUNT";
    }

    @Override
    protected String getTableName(LocalDate date) {
        return IndexingHistoryTablesUtil.getIndexingEventsCountTableName(date, date);
    }

    @Override
    protected String getTableCreateSpec(LocalDate tableDate, Instant updateTime) {
        return IndexingHistoryTablesUtil.getIndexingEventsCountUpdTableCreateSpec(tableDate, updateTime);
    }

    @Override
    protected String getDBName() {
        return IndexingHistoryTablesUtil.DATABASE_NAME;
    }

    @Override
    protected String getInsertSpec() {
        return IndexingHistoryTablesUtil.INDEXING_EVENTS_COUNT_INSERT_SPEC;
    }

    @Override
    protected IndexingHistoryImportType getImportType() {
        return IndexingHistoryImportType.EVENTS_COUNT_HISTORY;
    }

}
