package ru.yandex.webmaster3.worker.links;

import com.fasterxml.jackson.databind.JsonNode;
import lombok.Setter;
import org.joda.time.LocalDate;

import ru.yandex.webmaster3.storage.links.LinksImportService;
import ru.yandex.webmaster3.storage.util.yt.YtNode;
import ru.yandex.webmaster3.storage.ytimport.YtClickhouseDataLoad;
import ru.yandex.webmaster3.storage.ytimport.YtClickhouseDataLoadState;
import ru.yandex.webmaster3.worker.ytimport.AbstractYtClickhouseDataLoadTask;

/**
 * Задача автоматической загрузки ссылок из Clickhouse
 * Created by Oleg Bazdyrev on 18/05/2017.
 */
public class AbstractYtClickhouseLinksLoadTask extends AbstractYtClickhouseDataLoadTask {

    protected static final String PREPARAT_CURRENT_TIMESTAMP = "preparat_current_timestamp";

    @Setter
    private LinksImportService linksImportService;

    @Override
    protected YtClickhouseDataLoad init(YtClickhouseDataLoad latestImport) throws Exception {
        // берем из Yt нужную табличку. у нее смотрим preparat_current_timestamp и сравниваем с последним обработанным
        return ytService.withoutTransactionQuery(cypressService -> {
            YtNode node = cypressService.getNode(tablePath);
            JsonNode attr = node.getNodeMeta().get(PREPARAT_CURRENT_TIMESTAMP);
            if (attr != null) {
                // сравниваем с предыдущим значением
                LocalDate newDate = new LocalDate(attr.asLong(0L) * 1000L);
                if (latestImport.getDateTo() == null || newDate.isAfter(latestImport.getDateTo())) {
                    return latestImport.withSourceTable(tablePath, newDate, newDate);
                }
            }
            return latestImport.withState(YtClickhouseDataLoadState.DONE);
        });
    }

    @Override
    protected YtClickhouseDataLoad prepare(YtClickhouseDataLoad imprt) throws Exception {
        return linksImportService.prepareLinks(imprt).withNextState();
    }

    @Override
    protected YtClickhouseDataLoad doImport(YtClickhouseDataLoad imprt) throws Exception {
        return linksImportService.importLinks(imprt).withNextState();
    }

    @Override
    protected YtClickhouseDataLoad replicate(YtClickhouseDataLoad imprt) throws Exception {
        return linksImportService.replicateLinks(imprt).withNextState();
    }

}
