package ru.yandex.webmaster3.worker.links;

import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.fasterxml.jackson.databind.JsonNode;
import org.joda.time.LocalDate;

import ru.yandex.webmaster3.storage.util.yt.YtNode;
import ru.yandex.webmaster3.storage.util.yt.YtPath;
import ru.yandex.webmaster3.storage.ytimport.YtClickhouseDataLoad;
import ru.yandex.webmaster3.storage.ytimport.YtClickhouseDataLoadState;
import ru.yandex.webmaster3.storage.ytimport.YtClickhouseDataLoadType;

/**
 * Created by Oleg Bazdyrev on 23/05/2017.
 */
public class LinkStatisticsLoadTask extends AbstractYtClickhouseLinksLoadTask {

    private static final Pattern TABLE_NAME_PATTERN = Pattern.compile("report_(\\d+)");

    @Override
    protected YtClickhouseDataLoad init(YtClickhouseDataLoad latestImport) throws Exception {
        // ищем в YT последнюю необработанную табличку report_
        return ytService.withoutTransactionQuery(cypressService -> {
            List<YtPath> tables = cypressService.list(tablePath);
            tables.sort(Comparator.naturalOrder());
            for (YtPath table : tables) {
                Matcher matcher = TABLE_NAME_PATTERN.matcher(table.getName());
                if (!matcher.matches()) {
                    continue;
                }
                YtNode node = cypressService.getNode(table);
                JsonNode attr = node.getNodeMeta().get(PREPARAT_CURRENT_TIMESTAMP);
                if (attr != null) {
                    // сравниваем с предыдущим значением
                    LocalDate newDate = new LocalDate(attr.asLong(0L) * 1000L);
                    if (latestImport.getDateTo() == null || newDate.isAfter(latestImport.getDateTo())) {
                        return latestImport.withSourceTable(table, newDate, newDate);
                    }
                }
            }
            // ничего нового не нашли
            return latestImport.withState(YtClickhouseDataLoadState.DONE);
        });
    }

    @Override
    protected YtClickhouseDataLoadType getImportType() {
        return YtClickhouseDataLoadType.LINK_STATISTICS;
    }
}
