package ru.yandex.webmaster3.worker.metrika;

import lombok.RequiredArgsConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import ru.yandex.webmaster3.core.worker.task.PeriodicTaskState;
import ru.yandex.webmaster3.core.worker.task.PeriodicTaskType;
import ru.yandex.webmaster3.core.worker.task.TaskResult;
import ru.yandex.webmaster3.storage.metrika.dao.MetrikaCounterBindingStateYDao;
import ru.yandex.webmaster3.storage.util.ydb.exception.WebmasterYdbException;
import ru.yandex.webmaster3.worker.PeriodicTask;
import ru.yandex.webmaster3.worker.TaskSchedule;

import java.util.UUID;

/**
 * Created by ifilippov5 on 04.06.18.
 * По договоренности с Метрикой, мы регулярно чистим все провязки в тестинге
 */
@Service
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class ClearCountersInTestingPeriodicTask extends PeriodicTask<ClearCountersInTestingPeriodicTask.TaskState> {
    private static final Logger log = LoggerFactory.getLogger(ClearCountersInTestingPeriodicTask.class);

    private final MetrikaCounterBindingStateYDao metrikaCounterBindingStateYDao;
    @Value("${webmaster3.worker.metrika.productionMode}") private boolean productionMode;

    @Override
    public Result run(UUID runId) throws Exception {
        setState(new ClearCountersInTestingPeriodicTask.TaskState());
        if (!productionMode) {
            // TODO: очень странный код. кажется, здесь можно просто сделать truncate()
            metrikaCounterBindingStateYDao.forEachDomain(domain -> {
                try {
                    metrikaCounterBindingStateYDao.delete(domain);
                } catch (WebmasterYdbException e) {
                    throw new RuntimeException(e);
                }
            });
        }

        return new Result(TaskResult.SUCCESS);
    }

    @Override
    public PeriodicTaskType getType() {
        return PeriodicTaskType.METRIKA_CLEAR_COUNTERS_IN_TESTING;
    }

    @Override
    public TaskSchedule getSchedule() {
        return TaskSchedule.startByCron("0 0 0 * * 1");
    }

    public static class TaskState implements PeriodicTaskState {
    }
}
