package ru.yandex.webmaster3.worker.mirrors;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.worker.task.ChangeMainMirrorTaskData;
import ru.yandex.webmaster3.core.worker.task.TaskResult;
import ru.yandex.webmaster3.storage.mirrors.data.MirrorRequest;
import ru.yandex.webmaster3.storage.mirrors.data.MirrorRequestStateEnum;
import ru.yandex.webmaster3.storage.mirrors.service.MainMirrorService;
import ru.yandex.webmaster3.worker.RpsLimitedTask;

/**
 * @author tsyplyaev
 */
@Category("mirrors")
public class ChangeMainMirrorTask extends RpsLimitedTask<ChangeMainMirrorTaskData> {
    private static final Logger log = LoggerFactory.getLogger(ChangeMainMirrorTask.class);

    private MainMirrorService mainMirrorService;
    private MirrorRequestStateService mirrorRequestStateService;

    @Override
    public Result run(ChangeMainMirrorTaskData data) throws Exception {
        MirrorRequest latestRequest = mainMirrorService.getLatestRequest(data.getHostId());
        if (latestRequest == null) {
            return new Result(TaskResult.SUCCESS);
        }

        if (latestRequest.getState() != MirrorRequestStateEnum.NEW) {
            log.info("Latest request is not NEW: {} {} {}", latestRequest.getHostId(), latestRequest.getRequestId(),
                    latestRequest.getState());
            return new Result(TaskResult.SUCCESS);
        }

        if (mirrorRequestStateService.executeMirrorRequest(latestRequest)) {
            return new Result(TaskResult.SUCCESS);
        } else {
            return new Result(TaskResult.FAIL);
        }
    }

    @Override
    public Class<ChangeMainMirrorTaskData> getDataClass() {
        return ChangeMainMirrorTaskData.class;
    }

    @Required
    public void setMirrorRequestStateService(MirrorRequestStateService mirrorRequestStateService) {
        this.mirrorRequestStateService = mirrorRequestStateService;
    }

    @Required
    public void setMainMirrorService(MainMirrorService mainMirrorService) {
        this.mainMirrorService = mainMirrorService;
    }
}
