package ru.yandex.webmaster3.worker.mirrors;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.worker.task.SendMirrorChangeNotificationTaskData;
import ru.yandex.webmaster3.core.worker.task.TaskResult;
import ru.yandex.webmaster3.storage.events.data.events.RetranslateToUsersEvent;
import ru.yandex.webmaster3.storage.events.data.events.UserHostMessageEvent;
import ru.yandex.webmaster3.storage.events.service.WMCEventsService;
import ru.yandex.webmaster3.storage.user.message.content.MessageContent;
import ru.yandex.webmaster3.storage.user.notification.NotificationType;
import ru.yandex.webmaster3.worker.Task;

/**
 * @author avhaliullin
 */
@Category("notifications")
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
public class SendMirrorChangeNotificationTask extends Task<SendMirrorChangeNotificationTaskData> {
    private final WMCEventsService wmcEventsService;

    @Override
    public Result run(SendMirrorChangeNotificationTaskData data) throws Exception {
        wmcEventsService.addEvent(
                new RetranslateToUsersEvent<>(
                        UserHostMessageEvent.create(
                                data.getHostId(),
                                new MessageContent.MainMirrorChanged(data.getHostId(), data.getOldMirror(), data.getNewMirror()),
                                NotificationType.MAIN_MIRROR_UPDATE,
                                false
                        )
                )
        );
        return new Result(TaskResult.SUCCESS);
    }

    @Override
    public Class<SendMirrorChangeNotificationTaskData> getDataClass() {
        return SendMirrorChangeNotificationTaskData.class;
    }
}
