package ru.yandex.webmaster3.worker.mobile;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import ru.yandex.webmaster3.core.worker.task.HostMobileAuditTaskData;
import ru.yandex.webmaster3.storage.mobile.HostMobileAuditService;
import ru.yandex.webmaster3.worker.Task;

/**
 * @author leonidrom
 */
@Component
public class HostMobileAuditTask extends Task<HostMobileAuditTaskData> {
    private final HostMobileAuditService hostMobileAuditService;

    @Autowired
    public HostMobileAuditTask(HostMobileAuditService hostMobileAuditService) {
        this.hostMobileAuditService = hostMobileAuditService;
    }

    @Override
    public Result run(HostMobileAuditTaskData data) throws Exception {
        hostMobileAuditService.requestHostMobileAudit(data.getHostId());
        return Result.SUCCESS;
    }

    @Override
    public Class<HostMobileAuditTaskData> getDataClass() {
        return HostMobileAuditTaskData.class;
    }
}
