package ru.yandex.webmaster3.worker.notifications;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

import ru.yandex.webmaster3.core.checklist.data.SiteProblemTypeEnum;
import ru.yandex.webmaster3.storage.user.notification.NotificationType;

@Slf4j
public class NotificationTestHandler extends AbstractHandler {
    @Setter
    private NotificationTestService notificationTestService;

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (target.equals("/notification/templates")) {
            openNotificationTemplates(baseRequest, response);
            return;
        }
    }

    private void openNotificationTemplates(Request baseRequest, HttpServletResponse response) throws IOException {
        baseRequest.setHandled(true);

        response.setStatus(HttpServletResponse.SC_OK);
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/html");

        NotificationType notificationType;
        SiteProblemTypeEnum problemType = null;
        try {
            notificationType = NotificationType.valueOf(baseRequest.getParameter("type"));
        } catch (Exception e) {
            openHelpPage(response);
            return;
        }
        try {
            problemType = SiteProblemTypeEnum.valueOf(baseRequest.getParameter("problemType"));
        } catch (Exception ignore) {

        }
        openTemplatePage(response, notificationType, problemType);
    }

    private void openHelpPage(HttpServletResponse response) throws IOException {
        PrintWriter writer = response.getWriter();
        writer.print(
                "<!DOCTYPE html>\n" +
                        "<html lang=\"en\">\n" +
                        "<head>\n" +
                        "<link type=\"text/css\" rel=\"stylesheet\" href=\"http://yastatic.net/bootstrap/3.3.4/css/bootstrap.min.css\"/>\n" +
                        "</head>\n" +
                        "<body>\n" +
                        "<ul style=\"padding: 30px\">\n" +
                        "<li><a href=\"/digest/templates\" class=\"\">DIGEST</a><br/><br/></li>" +
                        "<li><a href=\"/postwelcome/template\" class=\"\">POST_WELCOME</a><br/><br/></li>"
        );
        for (NotificationType type : NotificationType.values()) {
            String style = "";
            if (!NotificationTestService.IMPLEMENTED_TYPES.contains(type)) {
                style = "text-muted";
                continue;
            }
            writer.print(String.format("<li><a href=\"/notification/templates?type=%1$s\" class=\"%2$s\">%1$s</a></li>", type.name(), style));
        }
        for (SiteProblemTypeEnum type : SiteProblemTypeEnum.values()) {
            String style = "";
            if (SiteProblemTypeEnum.DISABLED_PROBLEMS.contains(type)) {
                style = "text-muted";
            }
            writer.print(String.format(
                    "<li><a href=\"/notification/templates?type=SITE_PROBLEM_FATAL&problemType=%1$s\" class=\"%2$s\">%1$s</a></li>", type.name(), style));
        }
        writer.print(
                "</ul>\n" +
                        "</body>\n" +
                        "</html>\n"
        );
        writer.flush();
    }

    private void openTemplatePage(HttpServletResponse response,
                                  NotificationType notificationType,
                                  SiteProblemTypeEnum siteProblemTypeEnum) throws IOException {
        PrintWriter writer = response.getWriter();
        writer.print(notificationTestService.getHtml(notificationType, siteProblemTypeEnum));
        writer.flush();
    }
}
