package ru.yandex.webmaster3.worker.notifications.auto;

import org.joda.time.LocalDate;

import ru.yandex.webmaster3.core.checklist.data.SiteProblemTypeEnum;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.notification.UTMLabels;
import ru.yandex.webmaster3.core.sup.model.BellQuery;
import ru.yandex.webmaster3.core.util.IdUtils;
import ru.yandex.webmaster3.storage.user.message.content.MessageContent;
import ru.yandex.webmaster3.worker.notifications.auto.bell.model.SimpleBellMeta;

/**
 * ishalaru
 * 04.08.2020
 **/
public class BellNotificationTemplateUtil {
    private static final String DIAGNOSTIC_LINK = "https://webmaster.yandex.ru/site/%s/diagnosis/checklist/?%s";
    public static final String YA_SERVICE = "ya_webmaster";
    public static final String SERVICE_NAME = "webmaster";

    public static BellQuery.BellNotification createNotificationContent(WebmasterHostId hostId, MessageContent messageContent) {
        String hostName = hostId2Name(hostId);
        String hostIdForUrl = hostIdForUrl(hostId);
        String utmCampaign = messageContent.getType().name().toLowerCase();
        if (messageContent instanceof MessageContent.ChecklistChanges) {
            SiteProblemTypeEnum problemTypeEnum = ((MessageContent.ChecklistChanges) messageContent).getProblemType();
            utmCampaign = "checklist_changes_" + problemTypeEnum.name().toLowerCase();
        }
        UTMLabels utmLabels = UTMLabels.createBell(utmCampaign, LocalDate.now(), null);
        BellQuery.BellNotification result = null;

        switch (messageContent.getType()) {
            case CHECKLIST_CHANGES:
                MessageContent.ChecklistChanges checklistMessage = (MessageContent.ChecklistChanges) messageContent;
                BellQuery.BellNotification.BellMeta meta = buildChecklistChangesMessage(hostName, hostIdForUrl, utmLabels, checklistMessage);
                result = new BellQuery.BellNotification(YA_SERVICE, "webmaster." + checklistMessage.getProblemType().toString().toLowerCase(), SERVICE_NAME, meta);
                break;
        }

        return result;
    }


    private static BellQuery.BellNotification.BellMeta buildChecklistChangesMessage(String hostName,
                                                                                    String hostIdForUrl, UTMLabels utmLabels,
                                                                                    MessageContent.ChecklistChanges msg) {
        String link = String.format(DIAGNOSTIC_LINK, hostIdForUrl, utmLabels.getLabelsInQuery());
        BellQuery.BellNotification.BellMeta result;
        switch (msg.getProblemType()) {
            case DISALLOWED_IN_ROBOTS:
            case DNS_ERROR:
            case MORDA_ERROR:
            case THREATS:
            case SSL_CERTIFICATE_ERROR:
            case TOO_MANY_BROKEN_LINKS:
                result = SimpleBellMeta.create(link, hostName);
                break;
            default: {
                return null;
            }
        }
        return result;

    }

    private static String hostIdForUrl(WebmasterHostId hostId) {
        return hostId == null ? null : hostId.toString();
    }

    private static String hostId2Name(WebmasterHostId hostId) {
        return hostId == null ? null : IdUtils.toHostString(hostId, false, true, false);
    }

}
