package ru.yandex.webmaster3.worker.notifications.auto;

import java.util.Base64;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import ru.yandex.webmaster3.storage.abt.model.ExperimentInfo;

/**
 * ishalaru
 * 10.07.2020
 **/
@Service
public class ExtendedInfoService {
    @Value("${secrets.sign.info.key}")
    private String key;

    public String convert(ExperimentInfo experimentInfo, String notificationType) {
        StringBuilder answer = new StringBuilder();
        answer.append(System.currentTimeMillis()).append(";")
                .append(notificationType).append(";");
        if (experimentInfo != null) {
            answer.append(experimentInfo.experiment).append("=").append(experimentInfo.group).append(";");
        }
        Hasher h = Hashing.hmacSha256(key.getBytes()).newHasher();
        final Hasher hasher = h.putBytes(answer.toString().getBytes());
        String value = answer.append(";").append(hasher.hash().asLong()).append(";").toString();
        return Base64.getEncoder().encodeToString(value.getBytes());
    }
}
