package ru.yandex.webmaster3.worker.notifications.auto;

import java.util.stream.Collectors;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.notification.LanguageEnum;
import ru.yandex.webmaster3.core.notification.UTMLabels;
import ru.yandex.webmaster3.storage.user.message.content.MessageContent;
import ru.yandex.webmaster3.tanker.I18nEmailTexts;

/**
 * ishalaru
 * 13.01.2020
 **/
public class NewReviewNotificationTemplate {
    public static void renderTypeOneWithoutTail(StringBuilder body, LanguageEnum language, UTMLabels utmLabels, String hostName, WebmasterHostId hostId, MessageContent.NewReviewAvailable newReviewAvailable) {
        final String positive = I18nEmailTexts.NEW_REVIEW_BODY_POSITIVE
                .newBuilder(language)
                .utm(utmLabels)
                .count_positive(newReviewAvailable.getCountPositive(), String::valueOf)
                .render();
        final String negative = I18nEmailTexts.NEW_REVIEW_BODY_NEGATIVE
                .newBuilder(language)
                .utm(utmLabels)
                .count_negative(newReviewAvailable.getCountNegative(), String::valueOf)
                .render();

        I18nEmailTexts.NEW_REVIEW_BODY_VER1
                .newBuilder(language)
                .utm(utmLabels)
                .host(hostName)
                .str_positive(positive)
                .str_negative(negative)
                .renderTo(body);
    }

    public static void renderTypeOne(StringBuilder body, LanguageEnum language, UTMLabels utmLabels, String hostName, WebmasterHostId hostId, MessageContent.NewReviewAvailable newReviewAvailable) {
        renderTypeOneWithoutTail(body, language, utmLabels, hostName, hostId, newReviewAvailable);
        I18nEmailTexts.NEW_REVIEW_TAIL
                .newBuilder(language)
                .utm(utmLabels)
                .hostId(hostId.toString())
                .renderTo(body);
    }

    public static void renderTypeTwo(StringBuilder body, LanguageEnum language, UTMLabels utmLabels, String hostName, WebmasterHostId hostId, MessageContent.NewReviewAvailable newReviewAvailable) {
        renderTypeOneWithoutTail(body, language, utmLabels, hostName, hostId, newReviewAvailable);
        I18nEmailTexts.NEW_REVIEW_MESSAGES
                .newBuilder(language)
                .utm(utmLabels)
                .messages(String.join("\n", newReviewAvailable.getList().stream().map(e -> "<li>" + e + "</li>").collect(Collectors.toList())))
                .renderTo(body);
        I18nEmailTexts.NEW_REVIEW_TAIL
                .newBuilder(language)
                .utm(utmLabels)
                .hostId(hostId.toString())
                .renderTo(body);
    }

    public static void renderTypeTree(StringBuilder body, LanguageEnum language, UTMLabels utmLabels, String hostName, WebmasterHostId hostId, MessageContent.NewReviewAvailable newReviewAvailable) {
        final String positive = I18nEmailTexts.NEW_REVIEW_BODY_POSITIVE
                .newBuilder(language)
                .utm(utmLabels)
                .count_positive(newReviewAvailable.getCountPositive(), String::valueOf)
                .render();
        final String negative = I18nEmailTexts.NEW_REVIEW_BODY_NEGATIVE
                .newBuilder(language)
                .utm(utmLabels)
                .count_negative(newReviewAvailable.getCountNegative(), String::valueOf)
                .render();
        final String total = I18nEmailTexts.NEW_REVIEW_BODY_TOTAL
                .newBuilder(language)
                .utm(utmLabels)
                .total_count(newReviewAvailable.getCountNegative() + newReviewAvailable.getCountPositive(), String::valueOf)
                .render();
        I18nEmailTexts.NEW_REVIEW_BODY_VER2
                .newBuilder(language)
                .utm(utmLabels)
                .host(hostName)
                .str_positive(positive)
                .str_negative(negative)
                .str_total(total)
                .renderTo(body);
        I18nEmailTexts.NEW_REVIEW_MESSAGES
                .newBuilder(language)
                .utm(utmLabels)
                .messages(String.join("\n", newReviewAvailable.getList().stream().map(e -> "<li>" + e + "</li>").collect(Collectors.toList())))
                .renderTo(body);
        I18nEmailTexts.NEW_REVIEW_TAIL
                .newBuilder(language)
                .utm(utmLabels)
                .hostId(hostId.toString())
                .renderTo(body);
    }

}
