package ru.yandex.webmaster3.worker.notifications.auto;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.notification.LanguageEnum;
import ru.yandex.webmaster3.core.notification.UTMLabels;
import ru.yandex.webmaster3.storage.importanturls.data.ImportantUrlChange;
import ru.yandex.webmaster3.storage.importanturls.data.ImportantUrlsChange;
import ru.yandex.webmaster3.storage.user.message.MessageTypeEnum;
import ru.yandex.webmaster3.storage.user.message.content.MessageContent;
import ru.yandex.webmaster3.tanker.I18nEmailTexts;
import ru.yandex.webmaster3.worker.importanturls.I18nUtils;

/**
 * Created by ifilippov5 on 22.10.18.
 */
public class NotificationsImportantPagesTemplateUtil {

    public static void createEmailContent(LanguageEnum language, UTMLabels utmLabels,
                                          String hostName, WebmasterHostId hostId, StringBuilder subject, StringBuilder body,
                                          MessageContent messageContent, MessageTypeEnum messageType) {

        switch (messageType) {
            case URL_TITLE_CHANGE_ALL_HOST_PAGES:
                I18nEmailTexts.URL_TITLE_CHANGE_ALL_HOST_PAGES_subject
                        .newBuilder(language)
                        .utm(utmLabels)
                        .host(hostName)
                        .renderTo(subject);
                I18nEmailTexts.URL_TITLE_CHANGE_ALL_HOST_PAGES_body_prefix
                        .newBuilder(language)
                        .utm(utmLabels)
                        .renderTo(body);
                ImportantUrlsChange.TitleChangeAllHostPages content = (ImportantUrlsChange.TitleChangeAllHostPages) messageContent;
                for (ImportantUrlChange.TitleChange titleChange : content.getChanges()) {
                    I18nEmailTexts.URL_TITLE_CHANGE_ALL_HOST_PAGES_body_item
                            .newBuilder(language)
                            .utm(utmLabels)
                            .url(titleChange.getUrl())
                            .oldTitle(titleChange.getOldTitle())
                            .newTitle(titleChange.getNewTitle())
                            .hostId(titleChange.getHostId().toStringId())
                            .relativeUrl(titleChange.getRelativeUrl())
                            .renderTo(body);
                }
                I18nEmailTexts.URL_TITLE_CHANGE_ALL_HOST_PAGES_body_suffix
                        .newBuilder(language)
                        .utm(utmLabels)
                        .hostId(content.getHostId().toStringId())
                        .renderTo(body);
                break;
            case URL_DESCRIPTION_CHANGE_ALL_HOST_PAGES:
                I18nEmailTexts.URL_DESCRIPTION_CHANGE_ALL_HOST_PAGES_subject
                        .newBuilder(language)
                        .utm(utmLabels)
                        .host(hostName)
                        .renderTo(subject);
                I18nEmailTexts.URL_DESCRIPTION_CHANGE_ALL_HOST_PAGES_body_prefix
                        .newBuilder(language)
                        .utm(utmLabels)
                        .renderTo(body);
                ImportantUrlsChange.DescriptionChangeAllHostPages descriptionChangeContent = (ImportantUrlsChange.DescriptionChangeAllHostPages) messageContent;
                for (ImportantUrlChange.DescriptionChange descriptionChange : descriptionChangeContent.getChanges()) {
                    I18nEmailTexts.URL_DESCRIPTION_CHANGE_ALL_HOST_PAGES_body_item
                            .newBuilder(language)
                            .utm(utmLabels)
                            .url(descriptionChange.getUrl())
                            .oldDescription(descriptionChange.getOldDescription())
                            .newDescription(descriptionChange.getNewDescription())
                            .hostId(descriptionChange.getHostId().toStringId())
                            .relativeUrl(descriptionChange.getRelativeUrl())
                            .renderTo(body);
                }
                I18nEmailTexts.URL_DESCRIPTION_CHANGE_ALL_HOST_PAGES_body_suffix
                        .newBuilder(language)
                        .utm(utmLabels)
                        .hostId(descriptionChangeContent.getHostId().toStringId())
                        .renderTo(body);
                break;
            case URL_REL_CANONICAL_TARGET_CHANGE_ALL_HOST_PAGES:
                I18nEmailTexts.URL_REL_CANONICAL_TARGET_CHANGE_ALL_HOST_PAGES_subject
                        .newBuilder(language)
                        .utm(utmLabels)
                        .host(hostName)
                        .renderTo(subject);
                I18nEmailTexts.URL_REL_CANONICAL_TARGET_CHANGE_ALL_HOST_PAGES_body_prefix
                        .newBuilder(language)
                        .utm(utmLabels)
                        .renderTo(body);
                ImportantUrlsChange.RelCanonicalTargetChangeAllHostPages relCanonicalChangeContent = (ImportantUrlsChange.RelCanonicalTargetChangeAllHostPages) messageContent;
                for (ImportantUrlChange.RelCanonicalTargetChange relCanonicalTargetChange : relCanonicalChangeContent.getChanges()) {
                    I18nEmailTexts.URL_REL_CANONICAL_TARGET_CHANGE_ALL_HOST_PAGES_body_item
                            .newBuilder(language)
                            .utm(utmLabels)
                            .url(relCanonicalTargetChange.getUrl())
                            .oldRelCanonicalTarget(relCanonicalTargetChange.getOldRelCanonicalTarget())
                            .newRelCanonicalTarget(relCanonicalTargetChange.getNewRelCanonicalTarget())
                            .hostId(relCanonicalTargetChange.getHostId().toStringId())
                            .relativeUrl(relCanonicalTargetChange.getRelativeUrl())
                            .renderTo(body);
                }
                I18nEmailTexts.URL_REL_CANONICAL_TARGET_CHANGE_ALL_HOST_PAGES_body_suffix
                        .newBuilder(language)
                        .utm(utmLabels)
                        .hostId(relCanonicalChangeContent.getHostId().toStringId())
                        .renderTo(body);
                break;
            case URL_INDEXING_LAST_ACCESS_CHANGE_ALL_HOST_PAGES:
                ImportantUrlsChange.IndexingLastAccessChangeAllHostPages lastAccessChanges =
                        (ImportantUrlsChange.IndexingLastAccessChangeAllHostPages) messageContent;
                I18nEmailTexts.URL_INDEXING_LAST_ACCESS_CHANGE_ALL_HOST_PAGES_subject
                        .newBuilder(language)
                        .utm(utmLabels)
                        .host(hostName)
                        .newLastAccess(lastAccessChanges.getNewLastAccess())
                        .renderTo(subject);
                I18nEmailTexts.URL_INDEXING_LAST_ACCESS_CHANGE_ALL_HOST_PAGES_body_prefix
                        .newBuilder(language)
                        .utm(utmLabels)
                        .renderTo(body);

                for (ImportantUrlChange.IndexingLastAccessChange change : lastAccessChanges.getChanges()) {
                    I18nEmailTexts.URL_INDEXING_LAST_ACCESS_CHANGE_ALL_HOST_PAGES_body_item
                            .newBuilder(language)
                            .utm(utmLabels)
                            .url(change.getUrl())
                            .oldLastAccess(change.getOldLastAccess())
                            .newLastAccess(change.getNewLastAccess())
                            .hostId(change.getHostId().toStringId())
                            .relativeUrl(change.getRelativeUrl())
                            .renderTo(body);
                }
                I18nEmailTexts.URL_INDEXING_LAST_ACCESS_CHANGE_ALL_HOST_PAGES_body_suffix.newBuilder(language)
                        .utm(utmLabels)
                        .hostId(lastAccessChanges.getHostId().toStringId())
                        .renderTo(body);
                break;
            case URL_INDEXING_STATUS_CHANGE_ALL_HOST_PAGES:
                ImportantUrlsChange.HttpCodeChangeAllHostPages indexingStatusChanges =
                        (ImportantUrlsChange.HttpCodeChangeAllHostPages) messageContent;
                I18nEmailTexts.URL_INDEXING_STATUS_CHANGE_ALL_HOST_PAGES_subject
                        .newBuilder(language)
                        .utm(utmLabels)
                        .host(hostName)
                        .renderTo(subject);
                I18nEmailTexts.URL_INDEXING_STATUS_CHANGE_ALL_HOST_PAGES_body_prefix
                        .newBuilder(language)
                        .utm(utmLabels)
                        .renderTo(body);

                for (ImportantUrlChange.HttpCodeChange indexingStatusChange : indexingStatusChanges.getChanges()) {
                    I18nEmailTexts.URL_INDEXING_STATUS_CHANGE_ALL_HOST_PAGES_body_item
                            .newBuilder(language)
                            .utm(utmLabels)
                            .url(indexingStatusChange.getUrl())
                            .oldHttpCode(I18nUtils.getHttpCodeGroupName(indexingStatusChange.getOldHttpCode(), language))
                            .newHttpCode(I18nUtils.getHttpCodeGroupName(indexingStatusChange.getNewHttpCode(), language))
                            .hostId(indexingStatusChange.getHostId().toStringId())
                            .relativeUrl(indexingStatusChange.getRelativeUrl())
                            .renderTo(body);
                }
                I18nEmailTexts.URL_INDEXING_STATUS_CHANGE_ALL_HOST_PAGES_body_suffix
                        .newBuilder(language)
                        .utm(utmLabels)
                        .hostId(indexingStatusChanges.getHostId().toStringId())
                        .renderTo(body);
                break;
            case URL_SEARCH_LAST_ACCESS_CHANGE_ALL_HOST_PAGES:
                ImportantUrlsChange.SearchLastAccessChangeAllHostPages searchLastAccessChanges =
                        (ImportantUrlsChange.SearchLastAccessChangeAllHostPages) messageContent;

                I18nEmailTexts.URL_SEARCH_LAST_ACCESS_CHANGE_ALL_HOST_PAGES_subject
                        .newBuilder(language)
                        .utm(utmLabels)
                        .host(hostName)
                        .newLastAccess(searchLastAccessChanges.getNewLastAccess())
                        .renderTo(subject);

                I18nEmailTexts.URL_SEARCH_LAST_ACCESS_CHANGE_ALL_HOST_PAGES_body_prefix
                        .newBuilder(language)
                        .utm(utmLabels)
                        .renderTo(body);

                for (ImportantUrlChange.SearchLastAccessChange searchLastAccessChange : searchLastAccessChanges.getChanges()) {
                    I18nEmailTexts.URL_SEARCH_LAST_ACCESS_CHANGE_ALL_HOST_PAGES_body_item
                            .newBuilder(language)
                            .utm(utmLabels)
                            .url(searchLastAccessChange.getUrl())
                            .oldLastAccess(searchLastAccessChange.getOldLastAccess())
                            .newLastAccess(searchLastAccessChange.getNewLastAccess())
                            .hostId(searchLastAccessChange.getHostId().toStringId())
                            .relativeUrl(searchLastAccessChange.getRelativeUrl())
                            .renderTo(body);
                }
                I18nEmailTexts.URL_SEARCH_LAST_ACCESS_CHANGE_ALL_HOST_PAGES_body_suffix
                        .newBuilder(language)
                        .utm(utmLabels)
                        .hostId(searchLastAccessChanges.getHostId().toStringId())
                        .renderTo(body);
                break;
            case URL_SEARCH_STATUS_CHANGE_ALL_HOST_PAGES:
                ImportantUrlsChange.SearchUrlStatusChangeAllHostPages searchUrlStatusChanges =
                        (ImportantUrlsChange.SearchUrlStatusChangeAllHostPages) messageContent;

                I18nEmailTexts.URL_SEARCH_STATUS_CHANGE_ALL_HOST_PAGES_subject
                        .newBuilder(language)
                        .utm(utmLabels)
                        .host(hostName)
                        .renderTo(subject);

                I18nEmailTexts.URL_SEARCH_STATUS_CHANGE_ALL_HOST_PAGES_body_prefix
                        .newBuilder(language)
                        .utm(utmLabels)
                        .renderTo(body);

                for (ImportantUrlChange.SearchUrlStatusChange searchUrlStatusChange : searchUrlStatusChanges.getChanges()) {
                    String extendedDescription = I18nUtils.extendedDescription(
                            searchUrlStatusChange.getHostId(), searchUrlStatusChange.getRelativeUrl(),
                            searchUrlStatusChange.getNewSearchUrlStatus(), language
                    );

                    I18nEmailTexts.URL_SEARCH_STATUS_CHANGE_ALL_HOST_PAGES_body_item
                            .newBuilder(language)
                            .utm(utmLabels)
                            .url(searchUrlStatusChange.getUrl())
                            .oldSearchUrlStatus(I18nUtils.getUrlStatusTitle(
                                    searchUrlStatusChange.getOldSearchUrlStatus(), language))
                            .newSearchUrlStatus(I18nUtils.getUrlStatusTitle(
                                    searchUrlStatusChange.getNewSearchUrlStatus(), language))
                            .hostId(searchUrlStatusChange.getHostId().toStringId())
                            .relativeUrl(searchUrlStatusChange.getRelativeUrl())
                            .description(extendedDescription)
                            .renderTo(body);
                }
                I18nEmailTexts.URL_SEARCH_STATUS_CHANGE_ALL_HOST_PAGES_body_suffix
                    .newBuilder(language)
                    .utm(utmLabels)
                    .hostId(hostId.toString())
                    .renderTo(body);
                break;
        }

    }
}
