package ru.yandex.webmaster3.worker.notifications.auto;

import lombok.Value;
import org.joda.time.LocalDate;

import ru.yandex.webmaster3.core.checklist.data.SiteProblemContent;
import ru.yandex.webmaster3.core.checklist.data.SiteProblemSeverityEnum;
import ru.yandex.webmaster3.core.checklist.data.SiteProblemTypeEnum;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.notification.LanguageEnum;
import ru.yandex.webmaster3.core.notification.UTMLabels;
import ru.yandex.webmaster3.core.util.IdUtils;
import ru.yandex.webmaster3.storage.user.UserPersonalInfo;
import ru.yandex.webmaster3.storage.user.message.content.MessageContent;
import ru.yandex.webmaster3.storage.user.message.iks.IksMessageContent;
import ru.yandex.webmaster3.storage.user.message.iks.IksMessageType;
import ru.yandex.webmaster3.tanker.I18nSiteProblemSupTitle;
import ru.yandex.webmaster3.tanker.I18nSiteProblemSupTitleDefenition;
import ru.yandex.webmaster3.tanker.I18nSupBody;
import ru.yandex.webmaster3.tanker.I18nSupLink;
import ru.yandex.webmaster3.tanker.I18nSupTitle;

/**
 * ishalaru
 * 20.03.2020
 **/
public class SupNotificationTemplateUtil {

    public static SupContent createNotificationContent(WebmasterHostId hostId, UserPersonalInfo personalInfo, MessageContent messageContent) {
        LanguageEnum language = personalInfo.getLanguage();
        String hostName = hostId2Name(hostId);
        String hostIdForUrl = hostIdForUrl(hostId);
        String utmCampaign = messageContent.getType().name().toLowerCase();
        if (messageContent instanceof MessageContent.ChecklistChanges) {
            SiteProblemTypeEnum problemTypeEnum = ((MessageContent.ChecklistChanges) messageContent).getProblemType();
            utmCampaign = "checklist_changes_" + problemTypeEnum.name().toLowerCase();
        }
        UTMLabels utmLabels = UTMLabels.createSup(utmCampaign, LocalDate.now(), null);
        SupContent result = null;
        String longTitle = I18nSiteProblemSupTitle.SUP_COMMON_TITLE.getText(language);
        String shortTitle = I18nSiteProblemSupTitle.SHORT_SUP_COMMON_TITLE.getText(language);
        switch (messageContent.getType()) {
            case CHECKLIST_CHANGES: {
                MessageContent.ChecklistChanges checklistMessage = (MessageContent.ChecklistChanges) messageContent;
                result = buildChecklistChangesMessage(language, hostName, hostIdForUrl, utmLabels, checklistMessage);
                break;
            }
            case HOST_ACCESS_DELEGATED_TO_USER: {

                String title = I18nSupTitle.HOST_ACCESS_DELEGATED_TO_USER.newBuilder(language).host(hostName).render();
                String body = I18nSupBody.HOST_ACCESS_DELEGATED_TO_USER.newBuilder(language).utm(utmLabels).host(hostName).hostId(hostIdForUrl).render();
                String link = I18nSupLink.HOST_ACCESS_DELEGATED_TO_USER.newBuilder(language).utm(utmLabels).host(hostName).hostId(hostIdForUrl).render();
                result = new SupContent(shortTitle + ": " + title, body, link, "webmaster." + messageContent.getType().toString().toLowerCase(), true, longTitle, title);
                break;
            }
            case HOST_REGION_CHANGED: {
                String title = I18nSupTitle.HOST_REGION_CHANGED.newBuilder(language).host(hostName).render();
                String body = I18nSupBody.HOST_REGION_CHANGED.newBuilder(language).utm(utmLabels).host(hostName).hostId(hostIdForUrl).render();
                String link = I18nSupLink.HOST_REGION_CHANGED.newBuilder(language).utm(utmLabels).host(hostName).hostId(hostIdForUrl).render();
                result = new SupContent(shortTitle + ": " + title, body, link, "webmaster." + messageContent.getType().toString().toLowerCase(), true, longTitle, title);
                break;
            }
            case MAIN_MIRROR_CHANGED: {
                String title = I18nSupTitle.MAIN_MIRROR_CHANGED.newBuilder(language).host(hostName).render();
                String body = I18nSupBody.MAIN_MIRROR_CHANGED.newBuilder(language).utm(utmLabels).host(hostName).hostId(hostIdForUrl).render();
                String link = I18nSupLink.MAIN_MIRROR_CHANGED.newBuilder(language).utm(utmLabels).host(hostName).hostId(hostIdForUrl).render();
                result = new SupContent(shortTitle + ": " + title, body, link, "webmaster." + messageContent.getType().toString().toLowerCase(), true, longTitle, title);
                break;
            }
            case NEW_REVIEW: {
                String title = I18nSupTitle.NEW_REVIEW.newBuilder(language).host(hostName).render();
                String body = I18nSupBody.NEW_REVIEW.newBuilder(language).utm(utmLabels).host(hostName).hostId(hostIdForUrl).render();
                String link = I18nSupLink.NEW_REVIEW.newBuilder(language).utm(utmLabels).host(hostName).hostId(hostIdForUrl).render();
                result = new SupContent(shortTitle + ": " + title, body, link, "webmaster." + messageContent.getType().toString().toLowerCase(), true, longTitle, title);
                break;
            }
            case TURBO_ADV_SETTINGS_CHANGE: {
                String title = I18nSupTitle.TURBO_ADV_SETTINGS_CHANGE.newBuilder(language).host(hostName).render();
                String body = I18nSupBody.TURBO_ADV_SETTINGS_CHANGE.newBuilder(language).utm(utmLabels).host(hostName).hostId(hostIdForUrl).render();
                String link = I18nSupLink.TURBO_ADV_SETTINGS_CHANGE.newBuilder(language).utm(utmLabels).host(hostName).hostId(hostIdForUrl).render();
                result = new SupContent(shortTitle + ": " + title, body, link, "webmaster." + messageContent.getType().toString().toLowerCase(), true, longTitle, title);
                break;
            }
            case IKS_UPDATE: {
                if (((MessageContent.IksNewInfo)messageContent).getMessageType() == IksMessageType.UPDATE) {
                    String title = I18nSupTitle.SQI_UPDATE.newBuilder(language).host(hostName).render();
                    String body = I18nSupBody.SQI_UPDATE.newBuilder(language).utm(utmLabels).host(hostName).hostId(hostIdForUrl).render();
                    String link = I18nSupLink.SQI_UPDATE.newBuilder(language).utm(utmLabels).host(hostName).hostId(hostIdForUrl).render();
                    result = new SupContent(shortTitle + ": " + title, body, link, "webmaster." + messageContent.getType().toString().toLowerCase(), true, longTitle, title);
                }
                break;
            }
            default:
                break;
        }

        return result;
    }


    private static SupContent buildChecklistChangesMessage(LanguageEnum language, String hostName,
                                                           String hostIdForUrl, UTMLabels utmLabels,
                                                           MessageContent.ChecklistChanges msg) {

        String body;
        String link;
        switch (msg.getProblemType()) {
            case DISALLOWED_IN_ROBOTS: {
                body = I18nSupBody
                        .CHECKLIST_CHANGES_DISALLOWED_IN_ROBOTS
                        .newBuilder(language)
                        .utm(utmLabels)
                        .host(hostName)
                        .hostId(hostIdForUrl)
                        .render();
                link = I18nSupLink.CHECKLIST_CHANGES_DISALLOWED_IN_ROBOTS
                        .newBuilder(language)
                        .utm(utmLabels)
                        .host(hostName)
                        .hostId(hostIdForUrl)
                        .render();
                break;
            }
            case DNS_ERROR: {
                body = I18nSupBody
                        .CHECKLIST_CHANGES_DNS_ERROR
                        .newBuilder(language)
                        .utm(utmLabels)
                        .host(hostName)
                        .hostId(hostIdForUrl)
                        .render();
                link = I18nSupLink
                        .CHECKLIST_CHANGES_DNS_ERROR
                        .newBuilder(language)
                        .utm(utmLabels)
                        .host(hostName)
                        .hostId(hostIdForUrl)
                        .render();
                break;
            }
            case CONNECT_FAILED: {
                body = I18nSupBody
                        .CHECKLIST_CHANGES_CONNECT_FAILED
                        .newBuilder(language)
                        .utm(utmLabels)
                        .host(hostName)
                        .hostId(hostIdForUrl)
                        .render();
                link = I18nSupLink
                        .CHECKLIST_CHANGES_CONNECT_FAILED
                        .newBuilder(language)
                        .utm(utmLabels)
                        .host(hostName)
                        .hostId(hostIdForUrl)
                        .render();
                break;
            }
            case MORDA_ERROR: {
                body = I18nSupBody
                        .CHECKLIST_CHANGES_MORDA_ERROR
                        .newBuilder(language)
                        .utm(utmLabels)
                        .host(hostName)
                        .hostId(hostIdForUrl)
                        .render();
                link = I18nSupLink
                        .CHECKLIST_CHANGES_MORDA_ERROR
                        .newBuilder(language)
                        .utm(utmLabels)
                        .host(hostName)
                        .hostId(hostIdForUrl)
                        .render();
                break;

            }
            case THREATS: {
                body = I18nSupBody
                        .CHECKLIST_CHANGES_THREATS
                        .newBuilder(language)
                        .utm(utmLabels)
                        .host(hostName)
                        .hostId(hostIdForUrl)
                        .render();
                link = I18nSupLink
                        .CHECKLIST_CHANGES_THREATS
                        .newBuilder(language)
                        .utm(utmLabels)
                        .host(hostName)
                        .hostId(hostIdForUrl)
                        .render();
                break;
            }
            case SSL_CERTIFICATE_ERROR:
                body = I18nSupBody
                        .SSL_SERTIFICATE_ERROR
                        .newBuilder(language)
                        .utm(utmLabels)
                        .host(hostName)
                        .hostId(hostIdForUrl)
                        .render();
                link = I18nSupLink
                        .SSL_SERTIFICATE_ERROR
                        .newBuilder(language)
                        .utm(utmLabels)
                        .host(hostName)
                        .hostId(hostIdForUrl)
                        .render();
                break;
            case TOO_MANY_BROKEN_LINKS: {
                body = I18nSupBody
                        .CHECKLIST_CHANGES_TOO_MANY_BROKEN_LINKS
                        .newBuilder(language)
                        .utm(utmLabels)
                        .host(hostName)
                        .hostId(hostIdForUrl)
                        .render();
                link = I18nSupLink
                        .CHECKLIST_CHANGES_TOO_MANY_BROKEN_LINKS
                        .newBuilder(language)
                        .utm(utmLabels)
                        .host(hostName)
                        .hostId(hostIdForUrl)
                        .render();
                break;
            }

            case SLOW_AVG_RESPONSE: {
                final SiteProblemContent.SlowResponse problemContent = (SiteProblemContent.SlowResponse) msg.getProblemContent();
                body = I18nSupBody
                        .CHECKLIST_CHANGES_SLOW_AVG_RESPONSE
                        .newBuilder(language)
                        .utm(utmLabels)
                        .host(hostName)
                        .hostId(hostIdForUrl)
                        .render();
                link = I18nSupLink
                        .CHECKLIST_CHANGES_SLOW_AVG_RESPONSE
                        .newBuilder(language)
                        .utm(utmLabels)
                        .host(hostName)
                        .hostId(hostIdForUrl)
                        .render();
                break;
            }

            default: {
                return null;
            }
        }
        String projectTitle = I18nSiteProblemSupTitle.SUP_COMMON_TITLE.getText(language);
        String shortTitle = null;
        if (msg.getProblemType().getSeverity() == SiteProblemSeverityEnum.FATAL) {
            shortTitle = I18nSiteProblemSupTitleDefenition.FATAL_PROBLEM_TITLE.getText(language);
        } else if (msg.getProblemType().getSeverity() == SiteProblemSeverityEnum.CRITICAL) {
            shortTitle = I18nSiteProblemSupTitleDefenition.CRITICAL_PROBLEM_TITLE.getText(language);
        }
        SupContent supContent = new SupContent(shortTitle == null ? projectTitle : projectTitle + ": " + shortTitle, body, link, msg.getProblemType().toString(), true, projectTitle, shortTitle);
        return supContent;

    }

    private static String hostIdForUrl(WebmasterHostId hostId) {
        return hostId == null ? null : hostId.toString();
    }

    private static String hostId2Name(WebmasterHostId hostId) {
        return hostId == null ? null : IdUtils.toHostString(hostId, false, true, false);
    }


    @Value
    public static class SupContent {
        String title;
        String body;
        String link;
        String pushId;
        boolean isEnable;
        String projectTitle;
        String shortTitle;

    }
}
