package ru.yandex.webmaster3.worker.notifications.auto.bell.model;

import lombok.Value;

import ru.yandex.webmaster3.core.sup.model.BellQuery;

/**
 * ishalaru
 * 05.08.2020
 **/
@Value
public class SimpleBellMeta implements BellQuery.BellNotification.BellMeta {
    BellLink action;
    BellHost host;

    public static SimpleBellMeta create(String link, String text) {
        return new SimpleBellMeta(new BellLink(link), new BellHost(text));
    }

    @Value
    public static class BellLink extends AbstractBellType {
        String link;

        public BellLink(String link) {
            super(BellMetaType.LINK);
            this.link = link;
        }
    }

    @Value
    public static class BellHost extends AbstractBellType {
        String text;

        public BellHost(String text) {
            super(BellMetaType.TEXT);
            this.text = text;
        }
    }


}
