package ru.yandex.webmaster3.worker.notifications.info;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.storage.notifications.NotificationChannel;
import ru.yandex.webmaster3.storage.user.notification.NotificationType;

import java.util.Map;
import java.util.Set;

/**
 * Created by ifilippov5 on 29.08.17.
 */
public class UserHostsChannelsInfo {
    private final long userId;
    private final Map<WebmasterHostId, Map<NotificationType, Set<NotificationChannel>>> host2Settings;
    private final String email;
    private final String login;

    public UserHostsChannelsInfo(long userId, Map<WebmasterHostId, Map<NotificationType, Set<NotificationChannel>>> host2Settings, String email, String login) {
        this.userId = userId;
        this.host2Settings = host2Settings;
        this.email = email;
        this.login = login;
    }

    public long getUserId() {
        return userId;
    }

    public Map<WebmasterHostId, Map<NotificationType, Set<NotificationChannel>>> getHost2Settings() {
        return host2Settings;
    }

    public String getEmail() {
        return email;
    }

    public String getLogin() {
        return login;
    }
}
