package ru.yandex.webmaster3.worker.queue;

import java.util.UUID;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskType;

/**
 * @author aherman
 */
public class TaskId {
    private final WorkerTaskType taskType;
    private final WebmasterHostId hostId;
    private final UUID taskUUID;

    public TaskId(WorkerTaskType taskType, WebmasterHostId hostId, UUID taskUUID) {
        this.taskType = taskType;
        this.hostId = hostId;
        this.taskUUID = taskUUID;
    }

    public WorkerTaskType getTaskType() {
        return taskType;
    }

    public WebmasterHostId getHostId() {
        return hostId;
    }

    public UUID getTaskUUID() {
        return taskUUID;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        TaskId taskId1 = (TaskId) o;

        if (taskType != taskId1.taskType) {
            return false;
        }
        if (hostId != null ? !hostId.equals(taskId1.hostId) : taskId1.hostId != null) {
            return false;
        }
        return taskUUID.equals(taskId1.taskUUID);

    }

    @Override
    public int hashCode() {
        int result = taskType.hashCode();
        result = 31 * result + (hostId != null ? hostId.hashCode() : 0);
        result = 31 * result + taskUUID.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "TaskId[" + taskType + "/" + hostId + "/" + taskUUID + "]";
    }
}
