package ru.yandex.webmaster3.worker.queue;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskData;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskPriority;

/**
 * @author aherman
 */
public class TaskRunData {
    private final TaskId taskId;
    private final TaskRunType executorType;
    private final WorkerTaskData taskData;
    private final String taskDataStr;
    private final WorkerTaskPriority taskPriority;

    public TaskRunData(TaskId taskId, TaskRunType executorType, WorkerTaskData taskData, WorkerTaskPriority taskPriority) {
        this.taskId = taskId;
        this.executorType = executorType;
        this.taskData = taskData;
        this.taskDataStr = null;
        this.taskPriority = taskPriority;
    }

    public TaskRunData(@JsonProperty("taskId") TaskId taskId,
            @JsonProperty("executorType") TaskRunType executorType,
            @JsonProperty("taskData") String taskData)
    {
        this.taskId = taskId;
        this.executorType = executorType;
        this.taskData = null;
        this.taskDataStr = taskData;
        this.taskPriority = WorkerTaskPriority.NORMAL;
    }

    public TaskId getTaskId() {
        return taskId;
    }

    public TaskRunType getExecutorType() {
        return executorType;
    }

    public WorkerTaskData getTaskData() {
        return taskData;
    }

    public WorkerTaskPriority getTaskPriority() {
        return taskPriority;
    }

    @JsonIgnore
    String getTaskDataStr() {
        return taskDataStr;
    }

    public static<T extends WorkerTaskData> TaskRunData wrap(T taskData, WorkerTaskPriority priority) {
        TaskId taskId = new TaskId(taskData.getTaskType(), taskData.getHostId(), taskData.getTaskId());
        return new TaskRunData(taskId, TaskRunType.PRIMARY, taskData, priority);
    }
}
