package ru.yandex.webmaster3.worker.sanctions;

import java.util.UUID;

import lombok.RequiredArgsConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.webmaster3.core.worker.task.PeriodicTaskState;
import ru.yandex.webmaster3.core.worker.task.PeriodicTaskType;
import ru.yandex.webmaster3.core.worker.task.TaskResult;
import ru.yandex.webmaster3.storage.sanctions.SanctionsCHDao;
import ru.yandex.webmaster3.storage.util.clickhouse2.MergeFromTempTableService;
import ru.yandex.webmaster3.worker.PeriodicTask;
import ru.yandex.webmaster3.worker.TaskSchedule;

/**
 * Created by ifilippov5 on 22.08.17.
 */
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class MergeSanctionsFromTempTablesTask extends PeriodicTask<PeriodicTaskState> {
    private static final Logger log = LoggerFactory.getLogger(MergeSanctionsFromTempTablesTask.class);

    private final SanctionsCHDao sanctionsCHDao;
    private final MergeFromTempTableService mdbMergeFromTempTableService;

    @Override
    public Result run(UUID runId) throws Exception {
        mdbMergeFromTempTableService.mergeFrom(sanctionsCHDao);
        return new Result(TaskResult.SUCCESS);
    }

    @Override
    public PeriodicTaskType getType() {
        return PeriodicTaskType.MERGE_SANCTIONS;
    }

    @Override
    public TaskSchedule getSchedule() {
        return TaskSchedule.startByCron("0 */3 * * * *");
    }

}
