package ru.yandex.webmaster3.worker.searchquery;

import java.util.UUID;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import ru.yandex.webmaster3.core.worker.task.PeriodicTaskState;
import ru.yandex.webmaster3.core.worker.task.PeriodicTaskType;
import ru.yandex.webmaster3.storage.searchquery.dao.QueryGroupLimitsYDao;
import ru.yandex.webmaster3.storage.util.ydb.YdbYqlService;
import ru.yandex.webmaster3.storage.util.yt.YtPath;
import ru.yandex.webmaster3.worker.PeriodicTask;
import ru.yandex.webmaster3.worker.TaskSchedule;

/**
 * ishalaru
 * 17.05.2021
 **/
@Service
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
public class ImportGroupLimitsTask extends PeriodicTask<ImportGroupLimitsTask.State> {
    private static final String SELECT_QUERY = "select " +
            "CAST(host_id as Utf8) as host_id, CAST(`limits` as Integer) as `limits`, CAST(group_type as Int32) as group_type " +
            "FROM %s";
    private final QueryGroupLimitsYDao queryGroupLimitsYDao;
    private final YdbYqlService ydbYqlService;

    @Value("${webmaster3.worker.group.limit.path}")
    private YtPath path;


    @Override
    public Result run(UUID runId) throws Exception {
        ydbYqlService.importToYdb(queryGroupLimitsYDao.getTablePath(), String.format(SELECT_QUERY, path.toYqlPath()), "");
        return Result.SUCCESS;
    }

    @Override
    public PeriodicTaskType getType() {
        return PeriodicTaskType.IMPORT_GROUP_LIMITS;
    }

    @Override
    public TaskSchedule getSchedule() {
        return TaskSchedule.startByCron("0 0 4 * * *");
    }

    public class State implements PeriodicTaskState {
    }
}
